/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.utils.Bag;
import com.artemis.utils.ComparableTimSort;
import com.artemis.utils.TimSort;
import java.util.Comparator;

public class Sort {
    private static Sort instance;
    private TimSort timSort;
    private ComparableTimSort comparableTimSort;

    public <T> void sort(Bag<T> a) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a.data, 0, a.size());
    }

    public <T> void sort(T[] a) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a, 0, a.length);
    }

    public <T> void sort(T[] a, int fromIndex, int toIndex) {
        if (this.comparableTimSort == null) {
            this.comparableTimSort = new ComparableTimSort();
        }
        this.comparableTimSort.doSort(a, fromIndex, toIndex);
    }

    public <T> void sort(Bag<T> a, Comparator<T> c) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a.data, c, 0, a.size());
    }

    public <T> void sort(T[] a, Comparator<T> c) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a, c, 0, a.length);
    }

    public <T> void sort(T[] a, Comparator<T> c, int fromIndex, int toIndex) {
        if (this.timSort == null) {
            this.timSort = new TimSort();
        }
        this.timSort.doSort(a, c, fromIndex, toIndex);
    }

    public static Sort instance() {
        if (instance == null) {
            instance = new Sort();
        }
        return instance;
    }
}

