/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils.reflect;

import com.artemis.BaseEntitySystem;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySystem;
import com.artemis.Manager;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.Method;
import com.artemis.utils.reflect.ReflectionException;
import java.util.Arrays;

public final class ReflectionUtil {
    private static final Class<?>[] PARAM_ENTITY = new Class[]{Entity.class};
    private static final Class<?>[] PARAM_ID = new Class[]{Integer.TYPE};
    private static final Class<?>[] PARAM_IDS = new Class[]{IntBag.class};

    private ReflectionUtil() {
    }

    public static boolean implementsObserver(BaseSystem owner, String methodName) {
        try {
            Method method = ClassReflection.getMethod(owner.getClass(), methodName, PARAM_ENTITY);
            Class declarer = method.getDeclaringClass();
            return !Manager.class.equals((Object)declarer) && !EntitySystem.class.equals((Object)declarer);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean implementsAnyObserver(BaseEntitySystem owner) {
        if (ClassReflection.isInstance(Manager.class, owner) || ClassReflection.isInstance(EntitySystem.class, owner)) {
            return true;
        }
        for (Class<?> type = owner.getClass(); type != BaseEntitySystem.class; type = type.getSuperclass()) {
            for (Method m : ClassReflection.getDeclaredMethods(type)) {
                if (!ReflectionUtil.isObserver(m)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isObserver(Method m) {
        Object[] types;
        String name = m.getName();
        return !(!"inserted".equals(name) && !"removed".equals(name) || !Arrays.equals(PARAM_ID, types = m.getParameterTypes()) && !Arrays.equals(PARAM_IDS, types));
    }

    public static boolean isGenericType(Field f, Class<?> mainType, Class typeParameter) {
        return mainType == f.getType() && typeParameter == f.getElementType(0);
    }
}

