/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model;

import com.x5.template.Chunk;
import com.x5.template.Theme;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.onedaybeard.ecs.model.EcsTypeInspector;
import net.onedaybeard.ecs.model.MatrixData;
import net.onedaybeard.ecs.model.RowTypeMapping;
import net.onedaybeard.ecs.util.MatrixStringUtil;
import org.objectweb.asm.Opcodes;

public class ComponentDependencyMatrix
implements Opcodes {
    private final File root;
    private final File output;
    private final String projectName;

    public ComponentDependencyMatrix(String projectName, File root, File output) {
        this.projectName = projectName;
        this.root = root;
        this.output = output;
    }

    public String detectAndProcess() {
        for (String ecs : Arrays.asList("artemis", "ashley")) {
            EcsTypeInspector typeInspector = new EcsTypeInspector(this.root, "/" + ecs);
            if (!typeInspector.foundEcsClasses()) continue;
            this.process(typeInspector);
            return "Found ECS framework: " + ecs;
        }
        return "Failed finding any ECS related classes.";
    }

    public void process() {
        this.process("");
    }

    public void process(String resourcePrefix) {
        EcsTypeInspector typeInspector = new EcsTypeInspector(this.root, resourcePrefix);
        this.process(typeInspector);
    }

    private void process(EcsTypeInspector typeInspector) {
        this.write(typeInspector.getTypeMap(), typeInspector.getMatrixData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SortedMap<String, List<RowTypeMapping>> mappedSystems, MatrixData matrix) {
        Theme theme = new Theme();
        Chunk chunk = theme.makeChunk("matrix");
        ArrayList<RowTypeMapping> rows = new ArrayList<RowTypeMapping>();
        for (Map.Entry<String, List<RowTypeMapping>> entry : mappedSystems.entrySet()) {
            rows.add(new RowTypeMapping(entry.getKey()));
            rows.addAll((Collection)entry.getValue());
        }
        chunk.set("longestName", MatrixStringUtil.findLongestClassName(mappedSystems).replaceAll(".", "_") + "______");
        chunk.set("rows", rows);
        chunk.set("headersComponents", matrix.componentColumns);
        chunk.set("componentCount", matrix.componentColumns.size());
        chunk.set("headersManagers", matrix.managerColumns);
        chunk.set("managerCount", matrix.managerColumns.size());
        chunk.set("headersSystems", matrix.systemColumns);
        chunk.set("systemCount", matrix.systemColumns.size());
        chunk.set("factoryCount", matrix.factoryColumns.size());
        chunk.set("headersFactories", matrix.factoryColumns);
        chunk.set("project", this.projectName);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.output));
            chunk.render((Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

