/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.onedaybeard.ecs.model.MatrixData;
import net.onedaybeard.ecs.model.RowTypeMapping;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import net.onedaybeard.ecs.util.MatrixStringUtil;
import org.objectweb.asm.Type;

public class EcsMapping {
    final MatrixData matrixData;
    final List<RowTypeMapping> typeMappings;

    public EcsMapping(ConfigurationResolver resolver, List<EcsTypeData> artemisTypes) {
        SortedSet<Type> componentSet = EcsMapping.findComponents(artemisTypes);
        resolver.clearDefaultTypes();
        this.typeMappings = new ArrayList<RowTypeMapping>();
        Map<Type, Integer> componentIndices = EcsMapping.getComponentIndices(componentSet);
        for (EcsTypeData system : artemisTypes) {
            RowTypeMapping mappedType = RowTypeMapping.from(system, resolver, componentIndices);
            this.typeMappings.add(mappedType);
        }
        ArrayList<String> componentColumns = new ArrayList<String>();
        for (Type component : componentSet) {
            String name = component.getClassName();
            name = name.substring(name.lastIndexOf(46) + 1);
            componentColumns.add(name);
        }
        this.matrixData = new MatrixData(componentColumns, this.typeMappings);
        for (RowTypeMapping typeMapping : this.typeMappings) {
            typeMapping.setMatrixData(this.matrixData);
        }
    }

    private static SortedSet<Type> findComponents(List<EcsTypeData> ecsTypes) {
        TreeSet<Type> componentSet = new TreeSet<Type>(new ShortNameComparator());
        for (EcsTypeData ecs : ecsTypes) {
            componentSet.addAll(ecs.requires);
            componentSet.addAll(ecs.requiresOne);
            componentSet.addAll(ecs.optional);
            componentSet.addAll(ecs.exclude);
        }
        return componentSet;
    }

    private static Map<Type, Integer> getComponentIndices(SortedSet<Type> componentSet) {
        HashMap<Type, Integer> componentIndices = new HashMap<Type, Integer>();
        int index = 0;
        for (Type component : componentSet) {
            componentIndices.put(component, index++);
        }
        return componentIndices;
    }

    private static class ShortNameComparator
    implements Comparator<Type> {
        private ShortNameComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return MatrixStringUtil.shortName(o1).compareTo(MatrixStringUtil.shortName(o2));
        }
    }
}

