/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.onedaybeard.ecs.model.EcsMapping;
import net.onedaybeard.ecs.model.MatrixData;
import net.onedaybeard.ecs.model.RowTypeMapping;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import net.onedaybeard.ecs.util.ClassFinder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class EcsTypeInspector {
    private EcsMapping model = null;
    private final ConfigurationResolver initialTypeScan;

    public EcsTypeInspector(File root, String resourcePrefix) {
        this.initialTypeScan = new ConfigurationResolver(root, resourcePrefix);
        if (this.initialTypeScan.components.size() == 0 && this.initialTypeScan.systems.size() == 0 && this.initialTypeScan.managers.size() == 0 && this.initialTypeScan.factories.size() == 0) {
            String error = "No artemis classes found on classpath. See https://github.com/junkdog/artemis-odb/wiki/Component-Dependency-Matrix for more info.";
            throw new RuntimeException(error);
        }
        List<EcsTypeData> ecsTypes = this.findEcsTypes(root);
        if (ecsTypes.size() == 0) {
            return;
        }
        this.model = new EcsMapping(this.initialTypeScan, ecsTypes);
    }

    SortedMap<String, List<RowTypeMapping>> getTypeMap() {
        assert (this.model != null);
        String common = EcsTypeInspector.findCommonPackage(this.model.typeMappings);
        TreeMap<String, List<RowTypeMapping>> map = new TreeMap<String, List<RowTypeMapping>>();
        int s = this.model.typeMappings.size();
        for (int i = 0; s > i; ++i) {
            RowTypeMapping system = this.model.typeMappings.get(i);
            String packageName = EcsTypeInspector.toPackageName(system.ecsType.getClassName());
            String string = packageName = packageName.length() > common.length() ? packageName.substring(common.length()) : ".";
            if (!map.containsKey(packageName)) {
                map.put(packageName, new ArrayList());
            }
            ((List)map.get(packageName)).add(system);
        }
        return map;
    }

    MatrixData getMatrixData() {
        assert (this.model != null);
        return this.model.matrixData;
    }

    boolean foundEcsClasses() {
        return this.model != null;
    }

    private List<EcsTypeData> findEcsTypes(File root) {
        ArrayList<EcsTypeData> systems = new ArrayList<EcsTypeData>();
        for (File f : ClassFinder.find(root)) {
            this.inspectType(f, systems);
        }
        Collections.sort(systems, new TypeComparator());
        return systems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectType(File file, List<EcsTypeData> destination) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            ClassReader cr = new ClassReader((InputStream)stream);
            Type objectType = Type.getObjectType((String)cr.getClassName());
            if (!this.isEcsType(objectType)) {
                return;
            }
            EcsTypeData meta = this.initialTypeScan.scan(cr);
            meta.current = objectType;
            destination.add(meta);
        }
        catch (FileNotFoundException e) {
            System.err.println("not found: " + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isEcsType(Type objectType) {
        return this.initialTypeScan.managers.contains(objectType) || this.initialTypeScan.systems.contains(objectType) || this.initialTypeScan.factories.contains(objectType);
    }

    private static String findCommonPackage(List<RowTypeMapping> systems) {
        String prefix = EcsTypeInspector.toPackageName(systems.get((int)0).ecsType.getClassName());
        int s = systems.size();
        block0: for (int i = 1; s > i; ++i) {
            String p = EcsTypeInspector.toPackageName(systems.get((int)i).ecsType.getClassName());
            int l = Math.min(prefix.length(), p.length());
            for (int j = 0; l > j; ++j) {
                if (prefix.charAt(j) == p.charAt(j)) continue;
                prefix = prefix.substring(0, j);
                continue block0;
            }
        }
        return prefix;
    }

    private static String toPackageName(String className) {
        return className.substring(0, className.lastIndexOf(46));
    }

    private static class TypeComparator
    implements Comparator<EcsTypeData> {
        private TypeComparator() {
        }

        @Override
        public int compare(EcsTypeData o1, EcsTypeData o2) {
            return o1.current.toString().compareTo(o2.current.toString());
        }
    }
}

