/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.onedaybeard.ecs.model.RowTypeMapping;

public class MatrixData {
    final List<String> componentColumns;
    final List<String> managerColumns;
    final List<String> systemColumns;
    final List<String> factoryColumns;
    final Map<String, Integer> managerIndexMap;
    final Map<String, Integer> systemIndexMap;
    final Map<String, Integer> factoryIndexMap;

    MatrixData(List<String> componentColumns, List<RowTypeMapping> typeMappings) {
        this.componentColumns = new ArrayList<String>(componentColumns);
        this.managerColumns = new ArrayList<String>();
        this.systemColumns = new ArrayList<String>();
        this.factoryColumns = new ArrayList<String>();
        this.managerIndexMap = new HashMap<String, Integer>();
        this.systemIndexMap = new HashMap<String, Integer>();
        this.factoryIndexMap = new HashMap<String, Integer>();
        this.extractArtemisTypes(typeMappings);
    }

    private void extractArtemisTypes(List<RowTypeMapping> typeMappings) {
        TreeSet<String> referencedManagers = new TreeSet<String>();
        TreeSet<String> referencedSystems = new TreeSet<String>();
        TreeSet<String> referencedFactories = new TreeSet<String>();
        for (RowTypeMapping mapping : typeMappings) {
            MatrixData.insert(referencedManagers, mapping.refManagers);
            MatrixData.insert(referencedSystems, mapping.refSystems);
            MatrixData.insert(referencedFactories, mapping.refFactories);
        }
        int nextColumnIndex = 0;
        for (String manager : referencedManagers) {
            this.managerIndexMap.put(manager, nextColumnIndex++);
        }
        nextColumnIndex = 0;
        for (String system : referencedSystems) {
            this.systemIndexMap.put(system, nextColumnIndex++);
        }
        nextColumnIndex = 0;
        for (String factory : referencedFactories) {
            this.factoryIndexMap.put(factory, nextColumnIndex++);
        }
        this.managerColumns.addAll(referencedManagers);
        this.systemColumns.addAll(referencedSystems);
        this.factoryColumns.addAll(referencedFactories);
    }

    private static void insert(SortedSet<String> artemisSet, String[] referenced) {
        for (String ref : referenced) {
            artemisSet.add(ref);
        }
    }
}

