/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.onedaybeard.ecs.model.ComponentReference;
import net.onedaybeard.ecs.model.MatrixData;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import net.onedaybeard.ecs.util.MatrixStringUtil;
import org.objectweb.asm.Type;

public final class RowTypeMapping {
    public final EcsRowType rowType;
    public String symbol;
    public final Type ecsType;
    public final ComponentReference[] componentIndices;
    public final String name;
    public final String[] refSystems;
    public final String[] refManagers;
    public final String[] refFactories;
    public ComponentReference[] managerIndices;
    public ComponentReference[] systemIndices;
    public ComponentReference[] factoryIndices;
    public final boolean isPackage;

    public RowTypeMapping(String packageName) {
        this.name = packageName;
        this.ecsType = null;
        this.refSystems = null;
        this.refManagers = null;
        this.refFactories = null;
        this.componentIndices = null;
        this.symbol = null;
        this.rowType = EcsRowType.PACKAGE_NAME;
        this.isPackage = true;
    }

    private RowTypeMapping(EcsTypeData typeData, ConfigurationResolver resolver, ComponentReference[] componentIndices) {
        this.ecsType = typeData.current;
        this.componentIndices = componentIndices;
        this.name = MatrixStringUtil.shortName(this.ecsType);
        this.refManagers = RowTypeMapping.createNameIndices(typeData.managers);
        this.refSystems = RowTypeMapping.createNameIndices(typeData.systems);
        this.refFactories = RowTypeMapping.createNameIndices(typeData.factories);
        if (resolver.systems.contains(this.ecsType)) {
            this.rowType = EcsRowType.SYSTEM;
        } else if (resolver.managers.contains(this.ecsType)) {
            this.rowType = EcsRowType.MANAGER;
        } else if (resolver.factories.contains(this.ecsType)) {
            this.rowType = EcsRowType.FACTORY;
        } else {
            throw new RuntimeException();
        }
        this.symbol = this.rowType.symbol;
        this.isPackage = false;
    }

    private static String[] createNameIndices(Set<Type> types) {
        String[] typeNames = new String[types.size()];
        int index = 0;
        for (Type type : types) {
            typeNames[index++] = MatrixStringUtil.shortName(type);
        }
        return typeNames;
    }

    private static void filterComponentMappings(EcsTypeData typeData) {
        typeData.optional.removeAll(typeData.requires);
        typeData.optional.removeAll(typeData.requiresOne);
        typeData.optional.removeAll(typeData.exclude);
    }

    public static RowTypeMapping from(EcsTypeData typeData, ConfigurationResolver resolver, Map<Type, Integer> componentIndices) {
        RowTypeMapping.filterComponentMappings(typeData);
        ComponentReference[] components = new ComponentReference[componentIndices.size()];
        Arrays.fill((Object[])components, (Object)ComponentReference.NOT_REFERENCED);
        typeData.cleanSelfTypeReferences();
        RowTypeMapping.mapComponents(typeData.requires, ComponentReference.REQUIRED, componentIndices, components);
        RowTypeMapping.mapComponents(typeData.requiresOne, ComponentReference.ANY, componentIndices, components);
        RowTypeMapping.mapComponents(typeData.optional, ComponentReference.OPTIONAL, componentIndices, components);
        RowTypeMapping.mapComponents(typeData.exclude, ComponentReference.EXCLUDED, componentIndices, components);
        return new RowTypeMapping(typeData, resolver, components);
    }

    public void setMatrixData(MatrixData mapping) {
        this.managerIndices = RowTypeMapping.typeIndices(mapping.managerIndexMap, this.refManagers);
        this.systemIndices = RowTypeMapping.typeIndices(mapping.systemIndexMap, this.refSystems);
        this.factoryIndices = RowTypeMapping.typeIndices(mapping.factoryIndexMap, this.refFactories);
    }

    private static ComponentReference[] typeIndices(Map<String, Integer> indexMapping, String[] referenced) {
        ComponentReference[] indices = new ComponentReference[indexMapping.size()];
        Arrays.fill((Object[])indices, (Object)ComponentReference.NOT_REFERENCED);
        for (String ref : referenced) {
            indices[indexMapping.get((Object)ref).intValue()] = ComponentReference.OPTIONAL;
        }
        return indices;
    }

    public String getName() {
        return MatrixStringUtil.shortName(this.ecsType);
    }

    private static void mapComponents(Collection<Type> references, ComponentReference referenceType, Map<Type, Integer> componentIndices, ComponentReference[] components) {
        for (Type component : references) {
            components[componentIndices.get((Object)component).intValue()] = referenceType;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append('\"').append(this.getName()).append('\"');
        for (ComponentReference ref : this.componentIndices) {
            sb.append(", \"").append(ref.symbol).append('\"');
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static enum EcsRowType {
        PACKAGE_NAME(null),
        SYSTEM("gear"),
        MANAGER("gears"),
        FACTORY("user-plus"),
        POJO("coffee");

        public final String symbol;

        private EcsRowType(String symbol) {
            this.symbol = symbol;
        }
    }
}

