/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

class BindVisitor
extends AnnotationVisitor {
    private final EcsTypeData config;
    private final ConfigurationResolver resolver;

    public BindVisitor(EcsTypeData config, ConfigurationResolver resolver) {
        super(262144);
        this.config = config;
        this.resolver = resolver;
    }

    public AnnotationVisitor visitArray(String name) {
        assert ("value".equals(name));
        return new BindValueVisitor(this.config, this.resolver);
    }

    static boolean accepts(String desc) {
        return "Lcom/artemis/annotations/Bind;".equals(desc);
    }

    private static class BindValueVisitor
    extends AnnotationVisitor {
        private final EcsTypeData config;
        private final ConfigurationResolver resolver;

        public BindValueVisitor(EcsTypeData config, ConfigurationResolver resolver) {
            super(262144);
            this.config = config;
            this.resolver = resolver;
        }

        public void visit(String name, Object value) {
            if (this.resolver.components.contains(value)) {
                this.config.requires.add((Type)value);
            }
            super.visit(name, value);
        }
    }
}

