/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.onedaybeard.ecs.model.scan.EcsScanner;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import net.onedaybeard.ecs.model.scan.ParentChainFinder;
import net.onedaybeard.ecs.model.scan.SurfaceTypeCollector;
import net.onedaybeard.ecs.model.scan.TypeConfiguration;
import net.onedaybeard.ecs.util.ClassFinder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public final class ConfigurationResolver {
    public final String[] aspectRequire;
    public final String[] aspectRequireOne;
    public final String[] aspectExclude;
    public Set<Type> managers;
    public Set<Type> systems;
    public Set<Type> components;
    public Set<Type> factories;
    public Type componentMapper;
    private TypeConfiguration typeConfiguration;
    private final Map<Type, Set<Type>> parentChildrenMap;
    private final String resourcePrefix;

    public ConfigurationResolver(File rootFolder, String ecsResourcePrefix) {
        this.resourcePrefix = ecsResourcePrefix;
        if (!rootFolder.isDirectory()) {
            throw new RuntimeException("Expected folder - " + rootFolder);
        }
        this.managers = new HashSet<Type>();
        this.systems = new HashSet<Type>();
        this.components = new HashSet<Type>();
        this.factories = new HashSet<Type>();
        this.typeConfiguration = new TypeConfiguration(this.resourcePrefix);
        this.systems.addAll(this.typeConfiguration.systems);
        this.managers.addAll(this.typeConfiguration.managers);
        this.components.addAll(this.typeConfiguration.components);
        this.factories.addAll(this.typeConfiguration.factories);
        this.componentMapper = this.typeConfiguration.componentMapper;
        this.aspectRequire = this.typeConfiguration.aspectRequire;
        this.aspectRequireOne = this.typeConfiguration.aspectRequireOne;
        this.aspectExclude = this.typeConfiguration.aspectExclude;
        this.parentChildrenMap = new HashMap<Type, Set<Type>>();
        List<File> classes = ClassFinder.find(rootFolder);
        for (File f : classes) {
            this.findExtendedArtemisTypes(f);
        }
        ConfigurationResolver.resolveExtendedTypes(this.typeConfiguration, this.parentChildrenMap);
        for (File f : classes) {
            this.findArtemisTypes(f);
        }
    }

    private static void resolveExtendedTypes(TypeConfiguration main, Map<Type, Set<Type>> found) {
        main.systems = ConfigurationResolver.recursiveResolution(main.systems, found);
        main.managers = ConfigurationResolver.recursiveResolution(main.managers, found);
        main.components = ConfigurationResolver.recursiveResolution(main.components, found);
        main.factories = ConfigurationResolver.recursiveResolution(main.factories, found);
    }

    private static Set<Type> recursiveResolution(Set<Type> types, Map<Type, Set<Type>> found) {
        HashSet<Type> destination = new HashSet<Type>();
        for (Type t : types) {
            ConfigurationResolver.recursiveResolution(t, found, destination);
        }
        return destination;
    }

    private static void recursiveResolution(Type t, Map<Type, Set<Type>> found, Set<Type> destination) {
        if (found.containsKey(t)) {
            destination.add(t);
            for (Type foundType : found.get(t)) {
                ConfigurationResolver.recursiveResolution(foundType, found, destination);
            }
        }
    }

    public EcsTypeData scan(ClassReader source) {
        EcsTypeData info = new EcsTypeData();
        EcsScanner typeScanner = new EcsScanner(info, this);
        source.accept((ClassVisitor)typeScanner, 0);
        return info;
    }

    public void clearDefaultTypes() {
        TypeConfiguration tc = new TypeConfiguration(this.resourcePrefix);
        this.systems.removeAll(tc.systems);
        this.managers.removeAll(tc.managers);
        this.components.removeAll(tc.components);
        this.factories.removeAll(tc.factories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findExtendedArtemisTypes(FileInputStream stream) {
        try {
            ClassReader cr = new ClassReader((InputStream)stream);
            ParentChainFinder artemisTypeFinder = new ParentChainFinder(this.parentChildrenMap);
            cr.accept((ClassVisitor)artemisTypeFinder, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void findExtendedArtemisTypes(File file) {
        try {
            this.findExtendedArtemisTypes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            System.err.println("not found: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findEcsTypes(FileInputStream stream) {
        try {
            ClassReader cr = new ClassReader((InputStream)stream);
            SurfaceTypeCollector typeCollector = new SurfaceTypeCollector(this, this.typeConfiguration);
            cr.accept((ClassVisitor)typeCollector, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void findArtemisTypes(File file) {
        try {
            this.findEcsTypes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            System.err.println("not found: " + file);
        }
    }
}

