/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ConstructorScanner
extends MethodVisitor {
    private final EcsTypeData config;
    private final ConfigurationResolver resolver;
    private final Set<Type> queuedComponents;

    public ConstructorScanner(EcsTypeData config, ConfigurationResolver resolver) {
        super(262144);
        this.config = config;
        this.resolver = resolver;
        this.queuedComponents = new HashSet<Type>();
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type && this.resolver.components.contains(cst)) {
            this.queuedComponents.add((Type)cst);
        }
        super.visitLdcInsn(cst);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (Arrays.binarySearch(this.resolver.aspectRequire, name) >= 0) {
            this.config.requires.addAll(this.queuedComponents);
            this.queuedComponents.clear();
        } else if (Arrays.binarySearch(this.resolver.aspectRequireOne, name) >= 0) {
            this.config.requiresOne.addAll(this.queuedComponents);
            this.queuedComponents.clear();
        } else if (Arrays.binarySearch(this.resolver.aspectExclude, name) >= 0) {
            this.config.exclude.addAll(this.queuedComponents);
            this.queuedComponents.clear();
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }
}

