/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import net.onedaybeard.ecs.model.scan.BindVisitor;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.ConstructorScanner;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import net.onedaybeard.ecs.model.scan.MethodScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class EcsScanner
extends ClassVisitor {
    private final EcsTypeData config;
    private final ConfigurationResolver resolver;

    EcsScanner(EcsTypeData config, ConfigurationResolver configurationResolver) {
        super(262144);
        this.config = config;
        this.resolver = configurationResolver;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (BindVisitor.accepts(desc)) {
            return new BindVisitor(this.config, this.resolver);
        }
        return super.visitAnnotation(desc, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!desc.endsWith(";")) {
            return super.visitField(access, name, desc, signature, value);
        }
        Type type = Type.getType((String)desc);
        if (this.resolver.systems.contains(type)) {
            this.config.systems.add(type);
        } else if (this.resolver.managers.contains(type)) {
            this.config.managers.add(type);
        } else if (this.resolver.componentMapper.equals((Object)type)) {
            String componentDesc = signature.substring(signature.indexOf(60) + 1, signature.indexOf(62));
            this.config.optional.add(Type.getType((String)componentDesc));
        } else if (this.resolver.factories.contains(type)) {
            this.config.factories.add(type);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            return new ConstructorScanner(this.config, this.resolver);
        }
        return new MethodScanner(this.config, this.resolver);
    }
}

