/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import net.onedaybeard.ecs.model.scan.BindVisitor;
import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.EcsTypeData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodScanner
extends MethodVisitor {
    private EcsTypeData config;
    private ConfigurationResolver resolver;

    public MethodScanner(EcsTypeData config, ConfigurationResolver resolver) {
        super(262144);
        this.config = config;
        this.resolver = resolver;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (BindVisitor.accepts(desc)) {
            return new BindVisitor(this.config, this.resolver);
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            Type type = (Type)cst;
            if (this.resolver.components.contains(cst)) {
                this.config.optional.add(type);
            } else if (this.resolver.systems.contains(type)) {
                this.config.systems.add(type);
            } else if (this.resolver.managers.contains(type)) {
                this.config.managers.add(type);
            } else if (this.resolver.factories.contains(type)) {
                this.config.factories.add(type);
            }
        }
        super.visitLdcInsn(cst);
    }
}

