/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.onedaybeard.ecs.model.scan.TypeConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class ParentChainFinder
extends ClassVisitor {
    private Map<Type, Set<Type>> parentChildrenMap;

    public ParentChainFinder(Map<Type, Set<Type>> parentChildrenMap) {
        super(262144);
        this.parentChildrenMap = parentChildrenMap;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            Type visited = TypeConfiguration.type(name);
            if (!"java/lang/Object".equals(superName)) {
                this.addToMap(TypeConfiguration.type(superName), visited);
            }
            for (String iface : interfaces) {
                this.addToMap(TypeConfiguration.type(iface), visited);
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void addToMap(Type parent, Type child) {
        if (!this.parentChildrenMap.containsKey(parent)) {
            this.parentChildrenMap.put(parent, new HashSet());
        }
        this.parentChildrenMap.get(parent).add(child);
    }
}

