/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import net.onedaybeard.ecs.model.scan.ConfigurationResolver;
import net.onedaybeard.ecs.model.scan.TypeConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class SurfaceTypeCollector
extends ClassVisitor {
    private TypeConfiguration mainTypes;
    private ConfigurationResolver resolver;

    SurfaceTypeCollector(ConfigurationResolver resolver, TypeConfiguration mainTypes) {
        super(262144);
        this.resolver = resolver;
        this.mainTypes = mainTypes;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            Type superType = TypeConfiguration.type(superName);
            if (this.mainTypes.components.contains(superType)) {
                this.resolver.components.add(TypeConfiguration.type(name));
            } else if (this.mainTypes.systems.contains(superType)) {
                this.resolver.systems.add(TypeConfiguration.type(name));
            } else if (this.mainTypes.managers.contains(superType)) {
                this.resolver.managers.add(TypeConfiguration.type(name));
            } else if (!name.endsWith("Impl") && interfaces.length > 0) {
                for (String iface : interfaces) {
                    if (!this.mainTypes.factories.contains(TypeConfiguration.type(iface))) continue;
                    this.resolver.factories.add(TypeConfiguration.type(name));
                }
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }
}

