/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.model.scan;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.Type;

class TypeConfiguration {
    private String resourcePrefix;
    protected Set<Type> components = new HashSet<Type>();
    protected Set<Type> managers = new HashSet<Type>();
    protected Set<Type> systems = new HashSet<Type>();
    protected Set<Type> factories = new HashSet<Type>();
    public Type componentMapper;
    String[] aspectRequire;
    String[] aspectRequireOne;
    String[] aspectExclude;

    public TypeConfiguration(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.loadTypes();
        this.loadAspectMethods();
    }

    private void loadTypes() {
        HashMap<String, Set<Object>> keyToTypes = new HashMap<String, Set<Object>>();
        keyToTypes.put("COMPONENTS", this.components);
        keyToTypes.put("SYSTEMS", this.systems);
        keyToTypes.put("MANAGERS", this.managers);
        keyToTypes.put("FACTORIES", this.factories);
        keyToTypes.put("MAPPER", new HashSet());
        InputStream is = null;
        Set current = null;
        try {
            is = TypeConfiguration.class.getResourceAsStream(this.resourcePrefix + "/ecs-base-types.config");
            for (String s : IOUtils.readLines((InputStream)is)) {
                if (s.isEmpty() || s.startsWith("#")) continue;
                if (s.toUpperCase().equals(s)) {
                    current = (Set)keyToTypes.get(s);
                    assert (current != null);
                    continue;
                }
                TypeConfiguration.addType(s.trim(), current);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.componentMapper = (Type)((Set)keyToTypes.get("MAPPER")).iterator().next();
    }

    private void loadAspectMethods() {
        HashMap methodNames = new HashMap();
        methodNames.put("ASPECT_REQUIRE", new ArrayList());
        methodNames.put("ASPECT_REQUIRE_ONE", new ArrayList());
        methodNames.put("ASPECT_EXCLUDE", new ArrayList());
        InputStream is = null;
        List current = null;
        try {
            is = TypeConfiguration.class.getResourceAsStream(this.resourcePrefix + "/aspect-methods.config");
            for (String s : IOUtils.readLines((InputStream)is)) {
                if (s.isEmpty() || s.startsWith("#")) continue;
                if (s.toUpperCase().equals(s)) {
                    current = (List)methodNames.get(s);
                    assert (current != null);
                    continue;
                }
                current.add(s.trim());
                Collections.sort(current);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String[] string = new String[]{};
        this.aspectRequire = ((List)methodNames.get("ASPECT_REQUIRE")).toArray(string);
        this.aspectRequireOne = ((List)methodNames.get("ASPECT_REQUIRE_ONE")).toArray(string);
        this.aspectExclude = ((List)methodNames.get("ASPECT_EXCLUDE")).toArray(string);
    }

    static Type type(Class<?> klazz) {
        return TypeConfiguration.type(klazz.getName());
    }

    static Type type(String klazz) {
        klazz = klazz.replace('.', '/');
        return Type.getType((String)("L" + klazz + ";"));
    }

    static void addType(String qualifiedName, Set<Type> containerType) {
        containerType.add(TypeConfiguration.type(qualifiedName));
    }
}

