/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.ecs.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.onedaybeard.ecs.model.RowTypeMapping;
import org.objectweb.asm.Type;

public final class MatrixStringUtil {
    private MatrixStringUtil() {
    }

    public static String findLongestClassName(Map<String, List<RowTypeMapping>> mappings) {
        return MatrixStringUtil.findLongestString(mappings, new LongestClassName());
    }

    public static String findLongestManagerList(Map<String, List<RowTypeMapping>> mappings) {
        return MatrixStringUtil.findLongestString(mappings, new LongestManagers());
    }

    public static String findLongestSystemList(Map<String, List<RowTypeMapping>> mappings) {
        return MatrixStringUtil.findLongestString(mappings, new LongestSystems());
    }

    private static String findLongestString(Map<String, List<RowTypeMapping>> mappings, LongestMapper longestStrategy) {
        String longest = "";
        for (Map.Entry<String, List<RowTypeMapping>> entry : mappings.entrySet()) {
            if (entry.getKey().length() > longest.length()) {
                longest = entry.getKey();
            }
            for (RowTypeMapping mapping : entry.getValue()) {
                longest = longestStrategy.getMaxLength(mapping, longest);
            }
        }
        return longest;
    }

    public static String shortName(String s) {
        String name = s;
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String shortName(Type type) {
        String name = type.getClassName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static class LongestSystems
    implements LongestMapper {
        private LongestSystems() {
        }

        @Override
        public String getMaxLength(RowTypeMapping mapping, String longest) {
            return Arrays.toString(mapping.refSystems).length() > longest.length() ? Arrays.toString(mapping.refSystems) : longest;
        }
    }

    private static class LongestManagers
    implements LongestMapper {
        private LongestManagers() {
        }

        @Override
        public String getMaxLength(RowTypeMapping mapping, String longest) {
            return Arrays.toString(mapping.refManagers).length() > longest.length() ? Arrays.toString(mapping.refManagers) : longest;
        }
    }

    private static class LongestClassName
    implements LongestMapper {
        private LongestClassName() {
        }

        @Override
        public String getMaxLength(RowTypeMapping mapping, String longest) {
            return mapping.name.length() > longest.length() ? mapping.name : longest;
        }
    }

    private static interface LongestMapper {
        public String getMaxLength(RowTypeMapping var1, String var2);
    }
}

