package net.minestom.server.attribute;

import net.minestom.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * AUTOGENERATED by AttributeGenerator
 */
public enum Attributes {
    GENERIC_ARMOR(new Attribute("minecraft:generic.armor", 0.0f, 30.0f)),

    GENERIC_ARMOR_TOUGHNESS(new Attribute("minecraft:generic.armor_toughness", 0.0f, 20.0f)),

    GENERIC_ATTACK_DAMAGE(new Attribute("minecraft:generic.attack_damage", 2.0f, 2048.0f)),

    GENERIC_ATTACK_KNOCKBACK(new Attribute("minecraft:generic.attack_knockback", 0.0f, 5.0f)),

    GENERIC_ATTACK_SPEED(new Attribute("minecraft:generic.attack_speed", 4.0f, 1024.0f)),

    GENERIC_FLYING_SPEED(new Attribute("minecraft:generic.flying_speed", 0.4f, 1024.0f)),

    GENERIC_FOLLOW_RANGE(new Attribute("minecraft:generic.follow_range", 32.0f, 2048.0f)),

    HORSE_JUMP_STRENGTH(new Attribute("minecraft:horse.jump_strength", 0.7f, 2.0f)),

    GENERIC_KNOCKBACK_RESISTANCE(new Attribute("minecraft:generic.knockback_resistance", 0.0f, 1.0f)),

    GENERIC_LUCK(new Attribute("minecraft:generic.luck", 0.0f, 1024.0f)),

    GENERIC_MAX_ABSORPTION(new Attribute("minecraft:generic.max_absorption", 0.0f, 2048.0f)),

    GENERIC_MAX_HEALTH(new Attribute("minecraft:generic.max_health", 20.0f, 1024.0f)),

    GENERIC_MOVEMENT_SPEED(new Attribute("minecraft:generic.movement_speed", 0.7f, 1024.0f)),

    ZOMBIE_SPAWN_REINFORCEMENTS(new Attribute("minecraft:zombie.spawn_reinforcements", 0.0f, 1.0f));

    private static final Attributes[] VALUES = values();

    private final Attribute attribute;

    Attributes(@NotNull Attribute attribute) {
        this.attribute = attribute;
    }

    public @NotNull Attribute attribute() {
        return this.attribute;
    }

    @Nullable
    public static Attribute getValue(int id) {
        return VALUES[id].attribute;
    }

    public static void registerAttributes() {
        for (var v : VALUES) {
            MinecraftServer.getAttributeManager().register(v.attribute());
        }
    }
}
