package net.minestom.server.world.biomes;

import net.minestom.server.MinecraftServer;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * AUTOGENERATED by BiomeGenerator
 */
public enum Biomes {
    SNOWY_SLOPES(Biome.builder().name(NamespaceID.from("minecraft:snowy_slopes")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(-0.3f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x829fff).build()).build()),

    OLD_GROWTH_PINE_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:old_growth_pine_taiga")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.3f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ca3ff).build()).build()),

    MUSHROOM_FIELDS(Biome.builder().name(NamespaceID.from("minecraft:mushroom_fields")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.9f).downfall(1.0f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x77a8ff).build()).build()),

    TAIGA(Biome.builder().name(NamespaceID.from("minecraft:taiga")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.25f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da3ff).build()).build()),

    DEEP_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    ERODED_BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:eroded_badlands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).grassColor(0x90814d).foliageColor(0x9e814d).build()).build()),

    FROZEN_RIVER(Biome.builder().name(NamespaceID.from("minecraft:frozen_river")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3938c9).waterFogColor(0x050533).skyColor(0x7fa1ff).build()).build()),

    END_HIGHLANDS(Biome.builder().name(NamespaceID.from("minecraft:end_highlands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xa080a0).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x000000).build()).build()),

    CHERRY_GROVE(Biome.builder().name(NamespaceID.from("minecraft:cherry_grove")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x5db7ef).waterFogColor(0x5db7ef).skyColor(0x7ba4ff).grassColor(0xb6db61).foliageColor(0xb6db61).build()).build()),

    SUNFLOWER_PLAINS(Biome.builder().name(NamespaceID.from("minecraft:sunflower_plains")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x78a7ff).build()).build()),

    BIRCH_FOREST(Biome.builder().name(NamespaceID.from("minecraft:birch_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.6f).downfall(0.6f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7aa5ff).build()).build()),

    WINDSWEPT_HILLS(Biome.builder().name(NamespaceID.from("minecraft:windswept_hills")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da2ff).build()).build()),

    BAMBOO_JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:bamboo_jungle")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.95f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x77a8ff).build()).build()),

    WOODED_BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:wooded_badlands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).grassColor(0x90814d).foliageColor(0x9e814d).build()).build()),

    BADLANDS(Biome.builder().name(NamespaceID.from("minecraft:badlands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).grassColor(0x90814d).foliageColor(0x9e814d).build()).build()),

    SAVANNA_PLATEAU(Biome.builder().name(NamespaceID.from("minecraft:savanna_plateau")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    BEACH(Biome.builder().name(NamespaceID.from("minecraft:beach")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x78a7ff).build()).build()),

    DARK_FOREST(Biome.builder().name(NamespaceID.from("minecraft:dark_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x79a6ff).build()).build()),

    STONY_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:stony_peaks")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(1.0f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x76a8ff).build()).build()),

    MANGROVE_SWAMP(Biome.builder().name(NamespaceID.from("minecraft:mangrove_swamp")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3a7a6a).waterFogColor(0x4d7a60).skyColor(0x78a7ff).foliageColor(0x8db127).build()).build()),

    SPARSE_JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:sparse_jungle")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.95f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x77a8ff).build()).build()),

    LUKEWARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:lukewarm_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x45adf2).waterFogColor(0x041633).skyColor(0x7ba4ff).build()).build()),

    RIVER(Biome.builder().name(NamespaceID.from("minecraft:river")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    STONY_SHORE(Biome.builder().name(NamespaceID.from("minecraft:stony_shore")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da2ff).build()).build()),

    WARPED_FOREST(Biome.builder().name(NamespaceID.from("minecraft:warped_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x1a051a).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    SNOWY_PLAINS(Biome.builder().name(NamespaceID.from("minecraft:snowy_plains")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7fa1ff).build()).build()),

    DRIPSTONE_CAVES(Biome.builder().name(NamespaceID.from("minecraft:dripstone_caves")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x78a7ff).build()).build()),

    SNOWY_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:snowy_taiga")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(-0.5f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3d57d6).waterFogColor(0x050533).skyColor(0x839eff).build()).build()),

    GROVE(Biome.builder().name(NamespaceID.from("minecraft:grove")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(-0.2f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x81a0ff).build()).build()),

    SWAMP(Biome.builder().name(NamespaceID.from("minecraft:swamp")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x617b64).waterFogColor(0x232317).skyColor(0x78a7ff).foliageColor(0x6a7039).build()).build()),

    JAGGED_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:jagged_peaks")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(-0.7f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x859dff).build()).build()),

    COLD_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:cold_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3d57d6).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    FOREST(Biome.builder().name(NamespaceID.from("minecraft:forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x79a6ff).build()).build()),

    LUSH_CAVES(Biome.builder().name(NamespaceID.from("minecraft:lush_caves")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    BASALT_DELTAS(Biome.builder().name(NamespaceID.from("minecraft:basalt_deltas")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x685f70).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    DEEP_COLD_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_cold_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3d57d6).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    ICE_SPIKES(Biome.builder().name(NamespaceID.from("minecraft:ice_spikes")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7fa1ff).build()).build()),

    END_MIDLANDS(Biome.builder().name(NamespaceID.from("minecraft:end_midlands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xa080a0).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x000000).build()).build()),

    FROZEN_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:frozen_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.0f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3938c9).waterFogColor(0x050533).skyColor(0x7fa1ff).build()).build()),

    DESERT(Biome.builder().name(NamespaceID.from("minecraft:desert")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    DEEP_FROZEN_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_frozen_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3938c9).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    WINDSWEPT_FOREST(Biome.builder().name(NamespaceID.from("minecraft:windswept_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da2ff).build()).build()),

    JUNGLE(Biome.builder().name(NamespaceID.from("minecraft:jungle")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.95f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x77a8ff).build()).build()),

    OCEAN(Biome.builder().name(NamespaceID.from("minecraft:ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    OLD_GROWTH_SPRUCE_TAIGA(Biome.builder().name(NamespaceID.from("minecraft:old_growth_spruce_taiga")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.25f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da3ff).build()).build()),

    SNOWY_BEACH(Biome.builder().name(NamespaceID.from("minecraft:snowy_beach")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.05f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3d57d6).waterFogColor(0x050533).skyColor(0x7fa1ff).build()).build()),

    WINDSWEPT_SAVANNA(Biome.builder().name(NamespaceID.from("minecraft:windswept_savanna")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    END_BARRENS(Biome.builder().name(NamespaceID.from("minecraft:end_barrens")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xa080a0).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x000000).build()).build()),

    WARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:warm_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x43d5ee).waterFogColor(0x041f33).skyColor(0x7ba4ff).build()).build()),

    DEEP_LUKEWARM_OCEAN(Biome.builder().name(NamespaceID.from("minecraft:deep_lukewarm_ocean")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x45adf2).waterFogColor(0x041633).skyColor(0x7ba4ff).build()).build()),

    FLOWER_FOREST(Biome.builder().name(NamespaceID.from("minecraft:flower_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.7f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x79a6ff).build()).build()),

    SOUL_SAND_VALLEY(Biome.builder().name(NamespaceID.from("minecraft:soul_sand_valley")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x1b4745).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    NETHER_WASTES(Biome.builder().name(NamespaceID.from("minecraft:nether_wastes")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x330808).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    FROZEN_PEAKS(Biome.builder().name(NamespaceID.from("minecraft:frozen_peaks")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(-0.7f).downfall(0.9f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x859dff).build()).build()),

    THE_END(Biome.builder().name(NamespaceID.from("minecraft:the_end")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xa080a0).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x000000).build()).build()),

    SMALL_END_ISLANDS(Biome.builder().name(NamespaceID.from("minecraft:small_end_islands")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xa080a0).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x000000).build()).build()),

    OLD_GROWTH_BIRCH_FOREST(Biome.builder().name(NamespaceID.from("minecraft:old_growth_birch_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.6f).downfall(0.6f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7aa5ff).build()).build()),

    CRIMSON_FOREST(Biome.builder().name(NamespaceID.from("minecraft:crimson_forest")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0x330303).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    THE_VOID(Biome.builder().name(NamespaceID.from("minecraft:the_void")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.5f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    DEEP_DARK(Biome.builder().name(NamespaceID.from("minecraft:deep_dark")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x78a7ff).build()).build()),

    MEADOW(Biome.builder().name(NamespaceID.from("minecraft:meadow")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.5f).downfall(0.8f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x0e4ecf).waterFogColor(0x050533).skyColor(0x7ba4ff).build()).build()),

    WINDSWEPT_GRAVELLY_HILLS(Biome.builder().name(NamespaceID.from("minecraft:windswept_gravelly_hills")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.2f).downfall(0.3f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x7da2ff).build()).build()),

    SAVANNA(Biome.builder().name(NamespaceID.from("minecraft:savanna")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(2.0f).downfall(0.0f).showPrecipitation(false).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x6eb1ff).build()).build()),

    PLAINS(Biome.builder().name(NamespaceID.from("minecraft:plains")).category(Biome.Category.NONE).depth(0.125F).scale(0.05F).temperature(0.8f).downfall(0.4f).showPrecipitation(true).effects(BiomeEffects.builder().fogColor(0xc0d8ff).waterColor(0x3f76e4).waterFogColor(0x050533).skyColor(0x78a7ff).build()).build());

    private static final Biomes[] VALUES = Biomes.values();

    private final Biome biome;

    Biomes(@NotNull Biome biome) {
        this.biome = biome;
    }

    public @NotNull Biome biome() {
        return this.biome;
    }

    @Nullable
    public static Biomes getValue(int id) {
        return VALUES[id];
    }

    public static void registerBiomes() {
        for (var biome : VALUES) {
            MinecraftServer.getBiomeManager().addBiome(biome.biome());
        }
    }
}
