/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.Git;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.utils.debug.DebugUtils;
import org.bstats.MetricsBase;
import org.bstats.charts.CustomChart;
import org.bstats.charts.DrilldownPie;
import org.bstats.charts.SimplePie;
import org.bstats.charts.SingleLineChart;
import org.bstats.json.JsonObjectBuilder;

public class Metrics {
    private static String bStatsUuid = System.getProperty("minestom.bstats.id");
    private static final int SERVICE_ID = 20684;
    private MetricsBase metrics;

    public void start() {
        MinecraftServer.LOGGER.info("Enable bstats.");
        String serverUUID = bStatsUuid;
        if (serverUUID == null) {
            Path bStatsFile = Path.of(".bstats", new String[0]);
            if (Files.notExists(bStatsFile, new LinkOption[0])) {
                try {
                    Files.createFile(bStatsFile, new FileAttribute[0]);
                }
                catch (IOException e) {
                    MinecraftServer.LOGGER.error("BStats file cannot created.");
                    return;
                }
                try {
                    Files.writeString(bStatsFile, (CharSequence)UUID.randomUUID().toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    MinecraftServer.LOGGER.error("BStats file cannot be written.");
                    return;
                }
            }
            try {
                serverUUID = Files.readString(bStatsFile);
            }
            catch (IOException e) {
                MinecraftServer.LOGGER.error("BStats file cannot be readed.");
                return;
            }
        }
        System.setProperty("bstats.relocatecheck", "false");
        this.metrics = new MetricsBase("server-implementation", serverUUID, 20684, true, this::getServerData, jsonObjectBuilder -> {}, null, () -> true, (arg_0, arg_1) -> ((ComponentLogger)MinecraftServer.LOGGER).error(arg_0, arg_1), arg_0 -> ((ComponentLogger)MinecraftServer.LOGGER).info(arg_0), DebugUtils.INSIDE_TEST, DebugUtils.INSIDE_TEST, DebugUtils.INSIDE_TEST);
        this.metrics.addCustomChart((CustomChart)new SimplePie("minecraft_version", () -> {
            String minecraftVersion = "1.20.4";
            minecraftVersion = minecraftVersion.substring(minecraftVersion.indexOf("MC: ") + 4, minecraftVersion.length() - 1);
            return minecraftVersion;
        }));
        this.metrics.addCustomChart((CustomChart)new SingleLineChart("players", () -> MinecraftServer.getConnectionManager().getOnlinePlayers().size()));
        this.metrics.addCustomChart((CustomChart)new SimplePie("online_mode", () -> {
            if (MojangAuth.isEnabled()) {
                return "online";
            }
            if (VelocityProxy.isEnabled() || BungeeCordProxy.isEnabled()) {
                return "proxied";
            }
            return "offline";
        }));
        String paperVersion = "git-Microtus-%s-%s".formatted(Git.branch(), Git.commit());
        this.metrics.addCustomChart((CustomChart)new SimplePie("minestom_version", () -> paperVersion));
        this.metrics.addCustomChart((CustomChart)new DrilldownPie("java_version", () -> {
            String release;
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            String majorVersion = javaVersion.split("\\.")[0];
            int indexOf = javaVersion.lastIndexOf(46);
            if (majorVersion.equals("1")) {
                release = "Java " + javaVersion.substring(0, indexOf);
            } else {
                Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                if (versionMatcher.find()) {
                    majorVersion = versionMatcher.group(0);
                }
                release = "Java " + majorVersion;
            }
            map.put((CallSite)((Object)release), entry);
            return map;
        }));
        this.metrics.addCustomChart((CustomChart)new DrilldownPie("extensions", () -> {
            HashMap map = new HashMap();
            int extensions = MinecraftServer.getExtensionManager().getExtensions().size();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(String.valueOf(extensions), 1);
            if (extensions == 0) {
                map.put("0 \ud83d\ude0e", entry);
            } else if (extensions <= 5) {
                map.put("1-5", entry);
            } else if (extensions <= 10) {
                map.put("6-10", entry);
            } else if (extensions <= 25) {
                map.put("11-25", entry);
            } else if (extensions <= 50) {
                map.put("26-50", entry);
            } else {
                map.put("50+ \ud83d\ude2d", entry);
            }
            return map;
        }));
    }

    public void shutdown() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    private void getServerData(JsonObjectBuilder builder) {
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }
}

