/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.ServerProcessImpl;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.attribute.AttributeManager;
import net.minestom.server.command.CommandManager;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.extensions.ExtensionManager;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.item.armor.TrimManager;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.PacketProcessor;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.thread.TickSchedulerThread;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.Difficulty;
import net.minestom.server.world.DimensionTypeManager;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class MinecraftServer {
    public static final ComponentLogger LOGGER = ComponentLogger.logger(MinecraftServer.class);
    public static final String VERSION_NAME = "1.20.4";
    public static final int PROTOCOL_VERSION = 765;
    public static final String THREAD_NAME_BENCHMARK = "Ms-Benchmark";
    public static final String THREAD_NAME_TICK_SCHEDULER = "Ms-TickScheduler";
    public static final String THREAD_NAME_TICK = "Ms-Tick";
    @Deprecated
    public static final int TICK_PER_SECOND = ServerFlag.SERVER_TICKS_PER_SECOND;
    public static final int TICK_MS = 1000 / TICK_PER_SECOND;
    private static volatile ServerProcess serverProcess;
    private static int compressionThreshold;
    private static String brandName;
    private static Difficulty difficulty;

    public static MinecraftServer init() {
        MinecraftServer.updateProcess();
        return new MinecraftServer();
    }

    @ApiStatus.Internal
    public static ServerProcess updateProcess() {
        ServerProcessImpl process;
        try {
            process = new ServerProcessImpl();
            serverProcess = process;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return process;
    }

    @NotNull
    public static String getBrandName() {
        return brandName;
    }

    public static void setBrandName(@NotNull String brandName) {
        MinecraftServer.brandName = brandName;
        PacketUtils.broadcastPlayPacket(PluginMessagePacket.getBrandPacket());
    }

    @NotNull
    public static Difficulty getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(@NotNull Difficulty difficulty) {
        MinecraftServer.difficulty = difficulty;
        PacketUtils.broadcastPlayPacket(new ServerDifficultyPacket(difficulty, true));
    }

    @ApiStatus.Experimental
    public static @UnknownNullability ServerProcess process() {
        return serverProcess;
    }

    @NotNull
    public static GlobalEventHandler getGlobalEventHandler() {
        return serverProcess.eventHandler();
    }

    @NotNull
    public static PacketListenerManager getPacketListenerManager() {
        return serverProcess.packetListener();
    }

    @NotNull
    public static InstanceManager getInstanceManager() {
        return serverProcess.instance();
    }

    @NotNull
    public static BlockManager getBlockManager() {
        return serverProcess.block();
    }

    @NotNull
    public static CommandManager getCommandManager() {
        return serverProcess.command();
    }

    @NotNull
    public static RecipeManager getRecipeManager() {
        return serverProcess.recipe();
    }

    @NotNull
    public static TeamManager getTeamManager() {
        return serverProcess.team();
    }

    @NotNull
    public static SchedulerManager getSchedulerManager() {
        return serverProcess.scheduler();
    }

    @NotNull
    public static BenchmarkManager getBenchmarkManager() {
        return serverProcess.benchmark();
    }

    @NotNull
    public static ExceptionManager getExceptionManager() {
        return serverProcess.exception();
    }

    @NotNull
    public static ConnectionManager getConnectionManager() {
        return serverProcess.connection();
    }

    @NotNull
    public static BossBarManager getBossBarManager() {
        return serverProcess.bossBar();
    }

    @NotNull
    public static PacketProcessor getPacketProcessor() {
        return serverProcess.packetProcessor();
    }

    public static boolean isStarted() {
        return serverProcess.isAlive();
    }

    public static boolean isStopping() {
        return !MinecraftServer.isStarted();
    }

    @Deprecated
    public static int getChunkViewDistance() {
        return ServerFlag.CHUNK_VIEW_DISTANCE;
    }

    @Deprecated
    public static int getEntityViewDistance() {
        return ServerFlag.ENTITY_VIEW_DISTANCE;
    }

    public static int getCompressionThreshold() {
        return compressionThreshold;
    }

    public static void setCompressionThreshold(int compressionThreshold) {
        Check.stateCondition(serverProcess != null && serverProcess.isAlive(), "The compression threshold cannot be changed after the server has been started.");
        MinecraftServer.compressionThreshold = compressionThreshold;
    }

    public static DimensionTypeManager getDimensionTypeManager() {
        return serverProcess.dimension();
    }

    public static BiomeManager getBiomeManager() {
        return serverProcess.biome();
    }

    public static AttributeManager getAttributeManager() {
        return serverProcess.attribute();
    }

    public static AdvancementManager getAdvancementManager() {
        return serverProcess.advancement();
    }

    @Nullable
    public static ExtensionManager getExtensionManager() {
        return serverProcess.extension();
    }

    public static TagManager getTagManager() {
        return serverProcess.tag();
    }

    public static TrimManager getTrimManager() {
        return serverProcess.trim();
    }

    public static Server getServer() {
        return serverProcess.server();
    }

    public void start(@NotNull SocketAddress address) {
        serverProcess.start(address);
        new TickSchedulerThread(serverProcess).start();
    }

    public void start(@NotNull String address, int port) {
        this.start(new InetSocketAddress(address, port));
    }

    public static void stopCleanly() {
        serverProcess.stop();
    }

    static {
        compressionThreshold = 256;
        brandName = "Minestom";
        difficulty = Difficulty.NORMAL;
    }
}

