/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.advancements;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.advancements.AdvancementRoot;
import net.minestom.server.advancements.AdvancementTab;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementManager {
    private final Map<String, AdvancementTab> advancementTabMap = new ConcurrentHashMap<String, AdvancementTab>();

    @NotNull
    public AdvancementTab createTab(@NotNull String rootIdentifier, @NotNull AdvancementRoot root) {
        Check.stateCondition(this.advancementTabMap.containsKey(rootIdentifier), "A tab with the identifier '" + rootIdentifier + "' already exists");
        AdvancementTab advancementTab = new AdvancementTab(rootIdentifier, root);
        this.advancementTabMap.put(rootIdentifier, advancementTab);
        return advancementTab;
    }

    @Nullable
    public AdvancementTab getTab(@NotNull String rootIdentifier) {
        return this.advancementTabMap.get(rootIdentifier);
    }

    @NotNull
    public Collection<AdvancementTab> getTabs() {
        return this.advancementTabMap.values();
    }
}

