/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.EntitySoundEffectPacket;
import net.minestom.server.network.packet.server.play.SetTitleSubTitlePacket;
import net.minestom.server.network.packet.server.play.SetTitleTextPacket;
import net.minestom.server.network.packet.server.play.SetTitleTimePacket;
import net.minestom.server.network.packet.server.play.SoundEffectPacket;
import net.minestom.server.network.packet.server.play.StopSoundPacket;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.TickUtils;
import org.jetbrains.annotations.NotNull;

public class AdventurePacketConvertor {
    private static final Object2IntMap<NamedTextColor> NAMED_TEXT_COLOR_ID_MAP = new Object2IntArrayMap(16);

    private AdventurePacketConvertor() {
    }

    public static int getBossBarOverlayValue(@NotNull BossBar.Overlay overlay) {
        return overlay.ordinal();
    }

    public static byte getBossBarFlagValue(@NotNull Collection<BossBar.Flag> flags) {
        byte val = 0;
        for (BossBar.Flag flag : flags) {
            val = (byte)(val | flag.ordinal());
        }
        return val;
    }

    public static int getBossBarColorValue(@NotNull BossBar.Color color) {
        return color.ordinal();
    }

    public static int getSoundSourceValue(@NotNull Sound.Source source) {
        return source.ordinal();
    }

    public static int getNamedTextColorValue(@NotNull NamedTextColor color) {
        return NAMED_TEXT_COLOR_ID_MAP.getInt((Object)color);
    }

    @NotNull
    public static ServerPacket createSoundPacket(@NotNull Sound sound, double x, double y, double z) {
        SoundEvent minestomSound = SoundEvent.fromNamespaceId(sound.name().asString());
        long seed = sound.seed().orElse(ThreadLocalRandom.current().nextLong());
        if (minestomSound == null) {
            return new SoundEffectPacket(sound.name().asString(), null, sound.source(), (Point)new Vec(x, y, z), sound.volume(), sound.pitch(), seed);
        }
        return new SoundEffectPacket(minestomSound, null, sound.source(), (Point)new Vec(x, y, z), sound.volume(), sound.pitch(), seed);
    }

    @NotNull
    public static ServerPacket createSoundPacket(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        if (emitter == Sound.Emitter.self()) {
            throw new IllegalArgumentException("you must replace instances of Emitter.self() before calling this method");
        }
        if (!(emitter instanceof Entity)) {
            throw new IllegalArgumentException("you can only call this method with entities");
        }
        Entity entity = (Entity)emitter;
        SoundEvent minestomSound = SoundEvent.fromNamespaceId(sound.name().asString());
        long seed = sound.seed().orElse(ThreadLocalRandom.current().nextLong());
        if (minestomSound != null) {
            return new EntitySoundEffectPacket(minestomSound, null, sound.source(), entity.getEntityId(), sound.volume(), sound.pitch(), seed);
        }
        return new EntitySoundEffectPacket(sound.name().asString(), null, sound.source(), entity.getEntityId(), sound.volume(), sound.pitch(), seed);
    }

    public static ServerPacket createSoundStopPacket(@NotNull SoundStop stop) {
        Key soundKey;
        byte flags = 0;
        Sound.Source source = stop.source();
        String sound = null;
        if (source != null) {
            flags = (byte)(flags | 1);
        }
        if ((soundKey = stop.sound()) != null) {
            flags = (byte)(flags | 2);
            sound = soundKey.asString();
        }
        return new StopSoundPacket(flags, source, sound);
    }

    @NotNull
    public static <T> ServerPacket createTitlePartPacket(@NotNull TitlePart<T> part, @NotNull T value) {
        if (part == TitlePart.TITLE) {
            return new SetTitleTextPacket((Component)value);
        }
        if (part == TitlePart.SUBTITLE) {
            return new SetTitleSubTitlePacket((Component)value);
        }
        if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            return new SetTitleTimePacket(TickUtils.fromDuration(times.fadeIn(), 50), TickUtils.fromDuration(times.stay(), 50), TickUtils.fromDuration(times.fadeOut(), 50));
        }
        throw new IllegalArgumentException("Unknown TitlePart " + String.valueOf(part));
    }

    static {
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.BLACK, 0);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_BLUE, 1);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_GREEN, 2);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_AQUA, 3);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_RED, 4);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_PURPLE, 5);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.GOLD, 6);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.GRAY, 7);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.DARK_GRAY, 8);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.BLUE, 9);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.GREEN, 10);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.AQUA, 11);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.RED, 12);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.LIGHT_PURPLE, 13);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.YELLOW, 14);
        NAMED_TEXT_COLOR_ID_MAP.put((Object)NamedTextColor.WHITE, 15);
    }
}

