/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;

final class RayUtils {
    RayUtils() {
    }

    public static boolean BoundingBoxIntersectionCheck(BoundingBox moving, Point rayStart, Point rayDirection, BoundingBox collidableStatic, Point staticCollidableOffset, SweepResult finalResult) {
        double ziy;
        double xiy;
        double yFac;
        double yiz;
        double xiz;
        double zFac;
        double zix;
        double yix;
        double xFac;
        Vec bbCentre = new Vec(moving.minX() + moving.width() / 2.0, moving.minY() + moving.height() / 2.0, moving.minZ() + moving.depth() / 2.0);
        Point rayCentre = rayStart.add(bbCentre);
        Vec bbOffMin = new Vec(collidableStatic.minX() - rayCentre.x() + staticCollidableOffset.x() - moving.width() / 2.0, collidableStatic.minY() - rayCentre.y() + staticCollidableOffset.y() - moving.height() / 2.0, collidableStatic.minZ() - rayCentre.z() + staticCollidableOffset.z() - moving.depth() / 2.0);
        Vec bbOffMax = new Vec(collidableStatic.maxX() - rayCentre.x() + staticCollidableOffset.x() + moving.width() / 2.0, collidableStatic.maxY() - rayCentre.y() + staticCollidableOffset.y() + moving.height() / 2.0, collidableStatic.maxZ() - rayCentre.z() + staticCollidableOffset.z() + moving.depth() / 2.0);
        double signumRayX = Math.signum(rayDirection.x());
        double signumRayY = Math.signum(rayDirection.y());
        double signumRayZ = Math.signum(rayDirection.z());
        boolean isHit = false;
        double percentage = Double.MAX_VALUE;
        int collisionFace = -1;
        if (rayDirection.x() > 0.0 && (xFac = RayUtils.epsilon(bbOffMin.x() / rayDirection.x())) < percentage) {
            yix = rayDirection.y() * xFac + rayCentre.y();
            zix = rayDirection.z() * xFac + rayCentre.z();
            if ((yix - rayCentre.y()) * signumRayY >= 0.0 && (zix - rayCentre.z()) * signumRayZ >= 0.0 && yix >= collidableStatic.minY() + staticCollidableOffset.y() - moving.height() / 2.0 && yix <= collidableStatic.maxY() + staticCollidableOffset.y() + moving.height() / 2.0 && zix >= collidableStatic.minZ() + staticCollidableOffset.z() - moving.depth() / 2.0 && zix <= collidableStatic.maxZ() + staticCollidableOffset.z() + moving.depth() / 2.0) {
                isHit = true;
                percentage = xFac;
                collisionFace = 0;
            }
        }
        if (rayDirection.x() < 0.0 && (xFac = RayUtils.epsilon(bbOffMax.x() / rayDirection.x())) < percentage) {
            yix = rayDirection.y() * xFac + rayCentre.y();
            zix = rayDirection.z() * xFac + rayCentre.z();
            if ((yix - rayCentre.y()) * signumRayY >= 0.0 && (zix - rayCentre.z()) * signumRayZ >= 0.0 && yix >= collidableStatic.minY() + staticCollidableOffset.y() - moving.height() / 2.0 && yix <= collidableStatic.maxY() + staticCollidableOffset.y() + moving.height() / 2.0 && zix >= collidableStatic.minZ() + staticCollidableOffset.z() - moving.depth() / 2.0 && zix <= collidableStatic.maxZ() + staticCollidableOffset.z() + moving.depth() / 2.0) {
                isHit = true;
                percentage = xFac;
                collisionFace = 0;
            }
        }
        if (rayDirection.z() > 0.0 && (zFac = RayUtils.epsilon(bbOffMin.z() / rayDirection.z())) < percentage) {
            xiz = rayDirection.x() * zFac + rayCentre.x();
            yiz = rayDirection.y() * zFac + rayCentre.y();
            if ((yiz - rayCentre.y()) * signumRayY >= 0.0 && (xiz - rayCentre.x()) * signumRayX >= 0.0 && xiz >= collidableStatic.minX() + staticCollidableOffset.x() - moving.width() / 2.0 && xiz <= collidableStatic.maxX() + staticCollidableOffset.x() + moving.width() / 2.0 && yiz >= collidableStatic.minY() + staticCollidableOffset.y() - moving.height() / 2.0 && yiz <= collidableStatic.maxY() + staticCollidableOffset.y() + moving.height() / 2.0) {
                isHit = true;
                percentage = zFac;
                collisionFace = 1;
            }
        }
        if (rayDirection.z() < 0.0 && (zFac = RayUtils.epsilon(bbOffMax.z() / rayDirection.z())) < percentage) {
            xiz = rayDirection.x() * zFac + rayCentre.x();
            yiz = rayDirection.y() * zFac + rayCentre.y();
            if ((yiz - rayCentre.y()) * signumRayY >= 0.0 && (xiz - rayCentre.x()) * signumRayX >= 0.0 && xiz >= collidableStatic.minX() + staticCollidableOffset.x() - moving.width() / 2.0 && xiz <= collidableStatic.maxX() + staticCollidableOffset.x() + moving.width() / 2.0 && yiz >= collidableStatic.minY() + staticCollidableOffset.y() - moving.height() / 2.0 && yiz <= collidableStatic.maxY() + staticCollidableOffset.y() + moving.height() / 2.0) {
                isHit = true;
                percentage = zFac;
                collisionFace = 1;
            }
        }
        if (rayDirection.y() > 0.0 && (yFac = RayUtils.epsilon(bbOffMin.y() / rayDirection.y())) < percentage) {
            xiy = rayDirection.x() * yFac + rayCentre.x();
            ziy = rayDirection.z() * yFac + rayCentre.z();
            if ((ziy - rayCentre.z()) * signumRayZ >= 0.0 && (xiy - rayCentre.x()) * signumRayX >= 0.0 && xiy >= collidableStatic.minX() + staticCollidableOffset.x() - moving.width() / 2.0 && xiy <= collidableStatic.maxX() + staticCollidableOffset.x() + moving.width() / 2.0 && ziy >= collidableStatic.minZ() + staticCollidableOffset.z() - moving.depth() / 2.0 && ziy <= collidableStatic.maxZ() + staticCollidableOffset.z() + moving.depth() / 2.0) {
                isHit = true;
                percentage = yFac;
                collisionFace = 2;
            }
        }
        if (rayDirection.y() < 0.0 && (yFac = RayUtils.epsilon(bbOffMax.y() / rayDirection.y())) < percentage) {
            xiy = rayDirection.x() * yFac + rayCentre.x();
            ziy = rayDirection.z() * yFac + rayCentre.z();
            if ((ziy - rayCentre.z()) * signumRayZ >= 0.0 && (xiy - rayCentre.x()) * signumRayX >= 0.0 && xiy >= collidableStatic.minX() + staticCollidableOffset.x() - moving.width() / 2.0 && xiy <= collidableStatic.maxX() + staticCollidableOffset.x() + moving.width() / 2.0 && ziy >= collidableStatic.minZ() + staticCollidableOffset.z() - moving.depth() / 2.0 && ziy <= collidableStatic.maxZ() + staticCollidableOffset.z() + moving.depth() / 2.0) {
                isHit = true;
                percentage = yFac;
                collisionFace = 2;
            }
        }
        percentage *= 0.99999;
        if (isHit && percentage >= 0.0 && percentage <= finalResult.res) {
            finalResult.res = percentage;
            finalResult.normalX = 0.0;
            finalResult.normalY = 0.0;
            finalResult.normalZ = 0.0;
            if (collisionFace == 0) {
                finalResult.normalX = 1.0;
            }
            if (collisionFace == 1) {
                finalResult.normalZ = 1.0;
            }
            if (collisionFace == 2) {
                finalResult.normalY = 1.0;
            }
            return true;
        }
        return false;
    }

    private static double epsilon(double value) {
        return Math.abs(value) < 1.0E-6 ? 0.0 : value;
    }

    public static boolean BoundingBoxRayIntersectionCheck(Vec start, Vec direction, BoundingBox boundingBox, Pos position) {
        return RayUtils.BoundingBoxIntersectionCheck(BoundingBox.ZERO, start, direction, boundingBox, position, new SweepResult(Double.MAX_VALUE, 0.0, 0.0, 0.0, null, null));
    }
}

