/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.color;

import net.kyori.adventure.util.RGBLike;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record Color(int red, int green, int blue) implements RGBLike
{
    private static final int BIT_MASK = 255;

    public Color {
        Check.argCondition(!MathUtils.isBetween(red, 0, 255), "Red is not between 0-255: {0}", red);
        Check.argCondition(!MathUtils.isBetween(green, 0, 255), "Green is not between 0-255: {0}", green);
        Check.argCondition(!MathUtils.isBetween(blue, 0, 255), "Blue is not between 0-255: {0}", blue);
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public Color(@NotNull RGBLike rgbLike) {
        this(rgbLike.red(), rgbLike.green(), rgbLike.blue());
    }

    @NotNull
    public Color withRed(int red) {
        return new Color(red, this.green, this.blue);
    }

    @NotNull
    public Color withGreen(int green) {
        return new Color(this.red, green, this.blue);
    }

    @NotNull
    public Color withBlue(int blue) {
        return new Color(this.red, this.green, blue);
    }

    public int asRGB() {
        int rgb = this.red;
        rgb = (rgb << 8) + this.green;
        return (rgb << 8) + this.blue;
    }

    @NotNull
    public Color mixWith(RGBLike ... colors) {
        int r = this.red;
        int g = this.green;
        int b = this.blue;
        int max = Math.max(Math.max(r, g), b);
        for (RGBLike color : colors) {
            r += color.red();
            g += color.green();
            b += color.blue();
            max += Math.max(Math.max(color.red(), color.green()), color.blue());
        }
        float count = colors.length + 1;
        float averageRed = (float)r / count;
        float averageGreen = (float)g / count;
        float averageBlue = (float)b / count;
        float averageMax = (float)max / count;
        float maximumOfAverages = Math.max(Math.max(averageRed, averageGreen), averageBlue);
        float gainFactor = averageMax / maximumOfAverages;
        r = Math.round(averageRed * gainFactor);
        g = Math.round(averageGreen * gainFactor);
        b = Math.round(averageBlue * gainFactor);
        return new Color(r, g, b);
    }
}

