/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentBoolean
extends Argument<Boolean> {
    public static final int NOT_BOOLEAN_ERROR = 1;

    public ArgumentBoolean(String id) {
        super(id);
    }

    @Override
    @NotNull
    public Boolean parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        if (input.equalsIgnoreCase("true")) {
            return true;
        }
        if (input.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ArgumentSyntaxException("Not a boolean", input, 1);
    }

    @Override
    public String parser() {
        return "brigadier:bool";
    }

    public String toString() {
        return String.format("Boolean<%s>", this.getId());
    }
}

