/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.util.Map;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.block.BlockUtils;
import org.jetbrains.annotations.NotNull;

public class ArgumentBlockState
extends Argument<Block> {
    public static final int NO_BLOCK = 1;
    public static final int INVALID_BLOCK = 2;
    public static final int INVALID_PROPERTY = 3;
    public static final int INVALID_PROPERTY_VALUE = 4;

    public ArgumentBlockState(@NotNull String id) {
        super(id, true, false);
    }

    @Override
    @NotNull
    public Block parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        return ArgumentBlockState.staticParse(input);
    }

    @Override
    public String parser() {
        return "minecraft:block_state";
    }

    @Deprecated
    public static Block staticParse(@NotNull String input) throws ArgumentSyntaxException {
        int nbtIndex = input.indexOf("[");
        if (nbtIndex == 0) {
            throw new ArgumentSyntaxException("No block type", input, 1);
        }
        if (nbtIndex == -1) {
            Block block = Block.fromNamespaceId(input);
            if (block == null) {
                throw new ArgumentSyntaxException("Invalid block type", input, 2);
            }
            return block;
        }
        if (!input.endsWith("]")) {
            throw new ArgumentSyntaxException("Property list need to end with ]", input, 3);
        }
        String blockName = input.substring(0, nbtIndex);
        Block block = Block.fromNamespaceId(blockName);
        if (block == null) {
            throw new ArgumentSyntaxException("Invalid block type", input, 2);
        }
        String query = input.substring(nbtIndex);
        Map<String, String> propertyMap = BlockUtils.parseProperties(query);
        try {
            return block.withProperties(propertyMap);
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentSyntaxException("Invalid property values", input, 4);
        }
    }

    public String toString() {
        return String.format("BlockState<%s>", this.getId());
    }
}

