/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.Reader;
import java.io.StringReader;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.parser.SNBTParser;

public class ArgumentNbtTag
extends Argument<NBT> {
    public static final int INVALID_NBT = 1;

    public ArgumentNbtTag(String id) {
        super(id, true);
    }

    @Override
    @NotNull
    public NBT parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        try {
            return new SNBTParser((Reader)new StringReader(input)).parse();
        }
        catch (NBTException e) {
            throw new ArgumentSyntaxException("Invalid NBT", input, 1);
        }
    }

    @Override
    public String parser() {
        return "minecraft:nbt_tag";
    }

    public String toString() {
        return String.format("NBT<%s>", this.getId());
    }
}

