/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.utils.math.Range;
import org.jetbrains.annotations.NotNull;

public abstract class ArgumentRange<T extends Range<N>, N extends Number>
extends Argument<T> {
    public static final int FORMAT_ERROR = -1;
    private final N min;
    private final N max;
    private final Function<String, N> parser;
    private final BiFunction<N, N, T> rangeConstructor;

    ArgumentRange(@NotNull String id, N min, N max, Function<String, N> parser, BiFunction<N, N, T> rangeConstructor) {
        super(id);
        this.min = min;
        this.max = max;
        this.parser = parser;
        this.rangeConstructor = rangeConstructor;
    }

    @Override
    @NotNull
    public T parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        try {
            String[] split = input.split(Pattern.quote(".."), -1);
            if (split.length == 2) {
                Number max;
                Object min;
                if (split[0].length() == 0 && split[1].length() > 0) {
                    min = this.min;
                    max = (Number)this.parser.apply(split[1]);
                } else if (split[0].length() > 0 && split[1].length() == 0) {
                    min = (Number)this.parser.apply(split[0]);
                    max = this.max;
                } else if (split[0].length() > 0) {
                    min = (Number)this.parser.apply(split[0]);
                    max = (Number)this.parser.apply(split[1]);
                } else {
                    throw new ArgumentSyntaxException("Invalid range format", input, -1);
                }
                return (T)((Range)this.rangeConstructor.apply(min, max));
            }
            if (split.length == 1) {
                Number number = (Number)this.parser.apply(input);
                return (T)((Range)this.rangeConstructor.apply(number, number));
            }
        }
        catch (NumberFormatException e2) {
            throw new ArgumentSyntaxException("Invalid number", input, -1);
        }
        throw new ArgumentSyntaxException("Invalid range format", input, -1);
    }
}

