/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.display;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.EntityMeta;
import org.jetbrains.annotations.NotNull;

public class AbstractDisplayMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 23;

    protected AbstractDisplayMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    public int getTransformationInterpolationStartDelta() {
        return this.metadata.getIndex(8, 0);
    }

    public void setTransformationInterpolationStartDelta(int value) {
        this.metadata.setIndex(8, Metadata.VarInt(value));
    }

    public int getTransformationInterpolationDuration() {
        return this.metadata.getIndex(9, 0);
    }

    public void setTransformationInterpolationDuration(int value) {
        this.metadata.setIndex(9, Metadata.VarInt(value));
    }

    public int getPosRotInterpolationDuration() {
        return this.metadata.getIndex(10, 0);
    }

    public void setPosRotInterpolationDuration(int value) {
        this.metadata.setIndex(10, Metadata.VarInt(value));
    }

    @NotNull
    public Point getTranslation() {
        return this.metadata.getIndex(11, Vec.ZERO);
    }

    public void setTranslation(@NotNull Point value) {
        this.metadata.setIndex(11, Metadata.Vector3(value));
    }

    @NotNull
    public Vec getScale() {
        return this.metadata.getIndex(12, Vec.ONE);
    }

    public void setScale(@NotNull Vec value) {
        this.metadata.setIndex(12, Metadata.Vector3(value));
    }

    public float @NotNull [] getLeftRotation() {
        return this.metadata.getIndex(13, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
    }

    public void setLeftRotation(float @NotNull [] value) {
        this.metadata.setIndex(13, Metadata.Quaternion(value));
    }

    public float @NotNull [] getRightRotation() {
        return this.metadata.getIndex(14, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
    }

    public void setRightRotation(float @NotNull [] value) {
        this.metadata.setIndex(14, Metadata.Quaternion(value));
    }

    @NotNull
    public BillboardConstraints getBillboardRenderConstraints() {
        return BillboardConstraints.VALUES[this.metadata.getIndex(15, (byte)0)];
    }

    public void setBillboardRenderConstraints(@NotNull BillboardConstraints value) {
        this.metadata.setIndex(15, Metadata.Byte((byte)value.ordinal()));
    }

    public int getBrightnessOverride() {
        return this.metadata.getIndex(16, -1);
    }

    public void setBrightnessOverride(int value) {
        this.metadata.setIndex(16, Metadata.VarInt(value));
    }

    public float getViewRange() {
        return this.metadata.getIndex(17, Float.valueOf(1.0f)).floatValue();
    }

    public void setViewRange(float value) {
        this.metadata.setIndex(17, Metadata.Float(value));
    }

    public float getShadowRadius() {
        return this.metadata.getIndex(18, Float.valueOf(0.0f)).floatValue();
    }

    public void setShadowRadius(float value) {
        this.metadata.setIndex(18, Metadata.Float(value));
    }

    public float getShadowStrength() {
        return this.metadata.getIndex(19, Float.valueOf(1.0f)).floatValue();
    }

    public void setShadowStrength(float value) {
        this.metadata.setIndex(19, Metadata.Float(value));
    }

    public float getWidth() {
        return this.metadata.getIndex(20, Float.valueOf(0.0f)).floatValue();
    }

    public void setWidth(float value) {
        this.metadata.setIndex(20, Metadata.Float(value));
    }

    public float getHeight() {
        return this.metadata.getIndex(21, Float.valueOf(0.0f)).floatValue();
    }

    public void setHeight(float value) {
        this.metadata.setIndex(21, Metadata.Float(value));
    }

    public int getGlowColorOverride() {
        return this.metadata.getIndex(22, 0);
    }

    public void setGlowColorOverride(int value) {
        this.metadata.setIndex(22, Metadata.VarInt(value));
    }

    public static enum BillboardConstraints {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

        private static final BillboardConstraints[] VALUES;

        static {
            VALUES = BillboardConstraints.values();
        }
    }
}

