/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import com.extollit.gaming.ai.path.model.Gravitation;
import com.extollit.gaming.ai.path.model.IPathingEntity;
import com.extollit.gaming.ai.path.model.Passibility;
import com.extollit.linalg.immutable.Vec3d;
import net.minestom.server.attribute.Attribute;
import net.minestom.server.attribute.Attributes;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.pathfinding.Navigator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PFPathingEntity
implements IPathingEntity {
    private final Navigator navigator;
    private final Entity entity;
    private float searchRange;
    private boolean fireResistant;
    private boolean cautious;
    private boolean climber;
    private boolean swimmer;
    private boolean aquatic;
    private boolean avian;
    private boolean aquaphobic;
    private boolean avoidsDoorways;
    private boolean opensDoors;

    public PFPathingEntity(Navigator navigator) {
        this.navigator = navigator;
        this.entity = navigator.getEntity();
        this.searchRange = this.getAttributeValue(Attributes.GENERIC_FOLLOW_RANGE.attribute());
    }

    public int age() {
        return (int)this.entity.getAliveTicks();
    }

    public boolean bound() {
        return this.entity.hasVelocity();
    }

    public float searchRange() {
        return this.searchRange;
    }

    public void setSearchRange(float searchRange) {
        this.searchRange = searchRange;
    }

    public boolean isFireResistant() {
        return this.fireResistant;
    }

    public void setFireResistant(boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    public boolean isCautious() {
        return this.cautious;
    }

    public void setCautious(boolean cautious) {
        this.cautious = cautious;
    }

    public boolean isClimber() {
        return this.climber;
    }

    public void setClimber(boolean climber) {
        this.climber = climber;
    }

    public boolean isSwimmer() {
        return this.swimmer;
    }

    public void setSwimmer(boolean swimmer) {
        this.swimmer = swimmer;
    }

    public boolean isAquatic() {
        return this.aquatic;
    }

    public void setAquatic(boolean aquatic) {
        this.aquatic = aquatic;
    }

    public boolean isAvian() {
        return this.avian;
    }

    public void setAvian(boolean avian) {
        this.avian = avian;
    }

    public boolean isAquaphobic() {
        return this.aquaphobic;
    }

    public void setAquaphobic(boolean aquaphobic) {
        this.aquaphobic = aquaphobic;
    }

    public boolean isAvoidsDoorways() {
        return this.avoidsDoorways;
    }

    public void setAvoidsDoorways(boolean avoidsDoorways) {
        this.avoidsDoorways = avoidsDoorways;
    }

    public boolean isOpensDoors() {
        return this.opensDoors;
    }

    public void setOpensDoors(boolean opensDoors) {
        this.opensDoors = opensDoors;
    }

    public IPathingEntity.Capabilities capabilities() {
        return new IPathingEntity.Capabilities(){

            public float speed() {
                return PFPathingEntity.this.getAttributeValue(Attributes.GENERIC_MOVEMENT_SPEED.attribute());
            }

            public boolean fireResistant() {
                return PFPathingEntity.this.fireResistant;
            }

            public boolean cautious() {
                return PFPathingEntity.this.cautious;
            }

            public boolean climber() {
                return PFPathingEntity.this.climber;
            }

            public boolean swimmer() {
                return PFPathingEntity.this.swimmer;
            }

            public boolean aquatic() {
                return PFPathingEntity.this.aquatic;
            }

            public boolean avian() {
                return PFPathingEntity.this.avian;
            }

            public boolean aquaphobic() {
                return PFPathingEntity.this.aquaphobic;
            }

            public boolean avoidsDoorways() {
                return PFPathingEntity.this.avoidsDoorways;
            }

            public boolean opensDoors() {
                return PFPathingEntity.this.opensDoors;
            }
        };
    }

    public void moveTo(Vec3d position, Passibility passibility, Gravitation gravitation) {
        Vec targetPosition = new Vec(position.x, position.y, position.z);
        this.navigator.moveTowards(targetPosition, this.getAttributeValue(Attributes.GENERIC_MOVEMENT_SPEED.attribute()));
        double entityY = this.entity.getPosition().y() + 1.0E-5;
        if (entityY < targetPosition.y()) {
            this.navigator.jump(1.0f);
        }
    }

    public Vec3d coordinates() {
        Pos position = this.entity.getPosition();
        return new Vec3d(position.x(), position.y(), position.z());
    }

    public float width() {
        return (float)this.entity.getBoundingBox().width();
    }

    public float height() {
        return (float)this.entity.getBoundingBox().height();
    }

    private float getAttributeValue(@NotNull Attribute attribute) {
        if (this.entity instanceof LivingEntity) {
            return ((LivingEntity)this.entity).getAttributeValue(attribute);
        }
        return 0.0f;
    }
}

