/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.PlayerInstanceEvent;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class PlayerChangeHeldSlotEvent
implements PlayerInstanceEvent,
CancellableEvent {
    private final Player player;
    private byte slot;
    private boolean cancelled;

    public PlayerChangeHeldSlotEvent(@NotNull Player player, byte slot) {
        this.player = player;
        this.slot = slot;
    }

    public byte getSlot() {
        return this.slot;
    }

    public void setSlot(byte slot) {
        Check.argCondition(!MathUtils.isBetween((int)slot, 0, 8), "The held slot needs to be between 0 and 8");
        this.slot = slot;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

