/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extensions;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventNode;
import net.minestom.server.extensions.DiscoveredExtension;
import org.jetbrains.annotations.NotNull;

public final class ExtensionClassLoader
extends URLClassLoader {
    private final List<ExtensionClassLoader> children = new ArrayList<ExtensionClassLoader>();
    private final DiscoveredExtension discoveredExtension;
    private EventNode<Event> eventNode;
    private ComponentLogger logger;

    public ExtensionClassLoader(String name, URL[] urls, DiscoveredExtension discoveredExtension) {
        super("Ext_" + name, urls, MinecraftServer.class.getClassLoader());
        this.discoveredExtension = discoveredExtension;
    }

    public ExtensionClassLoader(String name, URL[] urls, ClassLoader parent, DiscoveredExtension discoveredExtension) {
        super("Ext_" + name, urls, parent);
        this.discoveredExtension = discoveredExtension;
    }

    @Override
    public void addURL(@NotNull URL url) {
        super.addURL(url);
    }

    public void addChild(@NotNull ExtensionClassLoader loader) {
        this.children.add(loader);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            for (ExtensionClassLoader child : this.children) {
                try {
                    return child.loadClass(name, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw e;
        }
    }

    public InputStream getResourceAsStreamWithChildren(@NotNull String name) {
        InputStream in = this.getResourceAsStream(name);
        if (in != null) {
            return in;
        }
        for (ExtensionClassLoader child : this.children) {
            InputStream childInput = child.getResourceAsStreamWithChildren(name);
            if (childInput == null) continue;
            return childInput;
        }
        return null;
    }

    public DiscoveredExtension getDiscoveredExtension() {
        return this.discoveredExtension;
    }

    public EventNode<Event> getEventNode() {
        if (this.eventNode == null) {
            this.eventNode = EventNode.all(this.discoveredExtension.getName());
            MinecraftServer.getGlobalEventHandler().addChild(this.eventNode);
        }
        return this.eventNode;
    }

    public ComponentLogger getLogger() {
        if (this.logger == null) {
            this.logger = ComponentLogger.logger((String)this.discoveredExtension.getName());
        }
        return this.logger;
    }

    void terminate() {
        if (this.eventNode != null) {
            MinecraftServer.getGlobalEventHandler().removeChild(this.eventNode);
        }
    }
}

