/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import com.extollit.gaming.ai.path.model.ColumnarOcclusionFieldList;
import com.extollit.gaming.ai.path.model.IBlockDescription;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.pathfinding.PFBlock;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.ChunkDataPacket;
import net.minestom.server.network.packet.server.play.UpdateLightPacket;
import net.minestom.server.network.packet.server.play.data.ChunkData;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.world.biomes.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicChunk
extends Chunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicChunk.class);
    protected List<Section> sections;
    protected final Int2ObjectOpenHashMap<Block> entries = new Int2ObjectOpenHashMap(0);
    protected final Int2ObjectOpenHashMap<Block> tickableMap = new Int2ObjectOpenHashMap(0);
    private long lastChange;
    final CachedPacket chunkCache = new CachedPacket(this::createChunkPacket);
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};

    public DynamicChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ, true);
        Section[] sectionsTemp = new Section[this.maxSection - this.minSection];
        Arrays.setAll(sectionsTemp, value -> new Section());
        this.sections = List.of(sectionsTemp);
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        if (y >= this.instance.getDimensionType().getMaxY() || y < this.instance.getDimensionType().getMinY()) {
            LOGGER.warn("tried to set a block outside the world bounds, should be within [{}, {}): {}", new Object[]{this.instance.getDimensionType().getMinY(), this.instance.getDimensionType().getMaxY(), y});
            return;
        }
        this.assertLock();
        this.lastChange = System.currentTimeMillis();
        this.chunkCache.invalidate();
        if (this.columnarSpace != null) {
            ColumnarOcclusionFieldList columnarOcclusionFieldList = this.columnarSpace.occlusionFields();
            PFBlock blockDescription = PFBlock.get(block);
            columnarOcclusionFieldList.onBlockChanged(x, y, z, (IBlockDescription)blockDescription, 0);
        }
        Section section = this.getSectionAt(y);
        section.blockPalette().set(ChunkUtils.toSectionRelativeCoordinate(x), ChunkUtils.toSectionRelativeCoordinate(y), ChunkUtils.toSectionRelativeCoordinate(z), block.stateId());
        int index = ChunkUtils.getBlockIndex(x, y, z);
        BlockHandler handler = block.handler();
        Block lastCachedBlock = handler != null || block.hasNbt() || block.registry().isBlockEntity() ? (Block)this.entries.put(index, (Object)block) : (Block)this.entries.remove(index);
        if (handler != null && handler.isTickable()) {
            this.tickableMap.put(index, (Object)block);
        } else {
            this.tickableMap.remove(index);
        }
        Vec blockPosition = new Vec(x, y, z);
        if (lastCachedBlock != null && lastCachedBlock.handler() != null) {
            lastCachedBlock.handler().onDestroy(Objects.requireNonNullElseGet(destroy, () -> new BlockHandler.Destroy(lastCachedBlock, this.instance, blockPosition)));
        }
        if (handler != null) {
            Block finalBlock = block;
            handler.onPlace(Objects.requireNonNullElseGet(placement, () -> new BlockHandler.Placement(finalBlock, this.instance, blockPosition)));
        }
    }

    @Override
    public void setBiome(int x, int y, int z, @NotNull Biome biome) {
        this.assertLock();
        this.chunkCache.invalidate();
        Section section = this.getSectionAt(y);
        section.biomePalette().set(ChunkUtils.toSectionRelativeCoordinate(x) / 4, ChunkUtils.toSectionRelativeCoordinate(y) / 4, ChunkUtils.toSectionRelativeCoordinate(z) / 4, biome.id());
    }

    @Override
    @NotNull
    public List<Section> getSections() {
        return this.sections;
    }

    @Override
    @NotNull
    public Section getSection(int section) {
        return this.sections.get(section - this.minSection);
    }

    @Override
    public void tick(long time) {
        if (this.tickableMap.isEmpty()) {
            return;
        }
        this.tickableMap.int2ObjectEntrySet().fastForEach(entry -> {
            int index = entry.getIntKey();
            Block block = (Block)entry.getValue();
            BlockHandler handler = block.handler();
            if (handler == null) {
                return;
            }
            Point blockPosition = ChunkUtils.getBlockPosition(index, this.chunkX, this.chunkZ);
            handler.tick(new BlockHandler.Tick(block, this.instance, blockPosition));
        });
    }

    @Override
    @Nullable
    public Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        this.assertLock();
        if (y < this.minSection * 16 || y >= this.maxSection * 16) {
            return Block.AIR;
        }
        if (condition != Block.Getter.Condition.TYPE) {
            Block entry;
            Block block = entry = !this.entries.isEmpty() ? (Block)this.entries.get(ChunkUtils.getBlockIndex(x, y, z)) : null;
            if (entry != null || condition == Block.Getter.Condition.CACHED) {
                return entry;
            }
        }
        Section section = this.getSectionAt(y);
        int blockStateId = section.blockPalette().get(ChunkUtils.toSectionRelativeCoordinate(x), ChunkUtils.toSectionRelativeCoordinate(y), ChunkUtils.toSectionRelativeCoordinate(z));
        return Objects.requireNonNullElse(Block.fromStateId((short)blockStateId), Block.AIR);
    }

    @Override
    @NotNull
    public Biome getBiome(int x, int y, int z) {
        this.assertLock();
        Section section = this.getSectionAt(y);
        int id = section.biomePalette().get(ChunkUtils.toSectionRelativeCoordinate(x) / 4, ChunkUtils.toSectionRelativeCoordinate(y) / 4, ChunkUtils.toSectionRelativeCoordinate(z) / 4);
        return MinecraftServer.getBiomeManager().getById(id);
    }

    @Override
    public long getLastChangeTime() {
        return this.lastChange;
    }

    @Override
    @NotNull
    public SendablePacket getFullDataPacket() {
        return this.chunkCache;
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        DynamicChunk dynamicChunk = new DynamicChunk(instance, chunkX, chunkZ);
        dynamicChunk.sections = this.sections.stream().map(Section::clone).toList();
        dynamicChunk.entries.putAll(this.entries);
        return dynamicChunk;
    }

    @Override
    public void reset() {
        for (Section section : this.sections) {
            section.clear();
        }
        this.entries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ChunkDataPacket createChunkPacket() {
        byte[] data;
        NBTCompound heightmapsNBT = this.computeHeightmap();
        DynamicChunk dynamicChunk = this;
        synchronized (dynamicChunk) {
            data = ObjectPool.PACKET_POOL.use(buffer -> NetworkBuffer.makeArray(networkBuffer -> {
                for (Section section : this.sections) {
                    networkBuffer.write(section);
                }
            }));
        }
        return new ChunkDataPacket(this.chunkX, this.chunkZ, new ChunkData(heightmapsNBT, data, (Map<Integer, Block>)this.entries), this.createLightData());
    }

    protected NBTCompound computeHeightmap() {
        int dimensionHeight = this.getInstance().getDimensionType().getHeight();
        int[] motionBlocking = new int[256];
        int[] worldSurface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                motionBlocking[x + z * 16] = 0;
                worldSurface[x + z * 16] = dimensionHeight - 1;
            }
        }
        int bitsForHeight = MathUtils.bitsToRepresent(dimensionHeight);
        return NBT.Compound(Map.of("MOTION_BLOCKING", NBT.LongArray((long[])DynamicChunk.encodeBlocks(motionBlocking, bitsForHeight)), "WORLD_SURFACE", NBT.LongArray((long[])DynamicChunk.encodeBlocks(worldSurface, bitsForHeight))));
    }

    @NotNull
    UpdateLightPacket createLightPacket() {
        return new UpdateLightPacket(this.chunkX, this.chunkZ, this.createLightData());
    }

    protected LightData createLightData() {
        BitSet skyMask = new BitSet();
        BitSet blockMask = new BitSet();
        BitSet emptySkyMask = new BitSet();
        BitSet emptyBlockMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        int index = 0;
        for (Section section : this.sections) {
            ++index;
            byte[] skyLight = section.skyLight().array();
            byte[] blockLight = section.blockLight().array();
            if (skyLight.length != 0) {
                skyLights.add(skyLight);
                skyMask.set(index);
            } else {
                emptySkyMask.set(index);
            }
            if (blockLight.length != 0) {
                blockLights.add(blockLight);
                blockMask.set(index);
                continue;
            }
            emptyBlockMask.set(index);
        }
        return new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
    }

    @Override
    @NotNull
    public ChunkSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        Section[] clonedSections = new Section[this.sections.size()];
        for (int i = 0; i < clonedSections.length; ++i) {
            clonedSections[i] = this.sections.get(i).clone();
        }
        Collection<Entity> entities = this.instance.getEntityTracker().chunkEntities(this.chunkX, this.chunkZ, EntityTracker.Target.ENTITIES);
        int[] entityIds = ArrayUtils.mapToIntArray(entities, Entity::getEntityId);
        return new SnapshotImpl.Chunk(this.minSection, this.chunkX, this.chunkZ, clonedSections, (Int2ObjectOpenHashMap<Block>)this.entries.clone(), entityIds, updater.reference(this.instance), this.tagHandler().readableCopy());
    }

    private void assertLock() {
        assert (Thread.holdsLock(this)) : "Chunk must be locked before access";
    }

    static long[] encodeBlocks(int[] blocks, int bitsPerEntry) {
        long maxEntryValue = (1L << bitsPerEntry) - 1L;
        char valuesPerLong = (char)(64 / bitsPerEntry);
        int magicIndex = 3 * (valuesPerLong - '\u0001');
        long divideMul = Integer.toUnsignedLong(MAGIC[magicIndex]);
        long divideAdd = Integer.toUnsignedLong(MAGIC[magicIndex + 1]);
        int divideShift = MAGIC[magicIndex + 2];
        int size = (blocks.length + valuesPerLong - 1) / valuesPerLong;
        long[] data = new long[size];
        for (int i = 0; i < blocks.length; ++i) {
            long value = blocks[i];
            int cellIndex = (int)((long)i * divideMul + divideAdd >> 32 >> divideShift);
            int bitIndex = (i - cellIndex * valuesPerLong) * bitsPerEntry;
            data[cellIndex] = data[cellIndex] & (maxEntryValue << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (value & maxEntryValue) << bitIndex;
        }
        return data;
    }
}

