/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.packet.server.play.ExplosionPacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public abstract class Explosion {
    private final float centerX;
    private final float centerY;
    private final float centerZ;
    private final float strength;

    protected Explosion(float centerX, float centerY, float centerZ, float strength) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.strength = strength;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    protected abstract List<Point> prepare(Instance var1);

    public void apply(@NotNull Instance instance) {
        List<Point> blocks = this.prepare(instance);
        byte[] records = new byte[3 * blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            Point pos = blocks.get(i);
            instance.setBlock(pos, Block.AIR);
            byte x = (byte)(pos.x() - Math.floor(this.getCenterX()));
            byte y = (byte)(pos.y() - Math.floor(this.getCenterY()));
            byte z = (byte)(pos.z() - Math.floor(this.getCenterZ()));
            records[i * 3 + 0] = x;
            records[i * 3 + 1] = y;
            records[i * 3 + 2] = z;
        }
        ExplosionPacket packet = new ExplosionPacket(this.centerX, this.centerY, this.centerZ, this.strength, records, 0.0f, 0.0f, 0.0f);
        this.postExplosion(instance, blocks, packet);
        PacketUtils.sendGroupedPacket(instance.getPlayers(), packet);
        this.postSend(instance, blocks);
    }

    protected void postExplosion(Instance instance, List<Point> blocks, ExplosionPacket packet) {
    }

    protected void postSend(Instance instance, List<Point> blocks) {
    }
}

