/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Collection;
import net.minestom.server.item.EnchantmentImpl;
import net.minestom.server.item.Enchantments;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Enchantment
extends ProtocolObject,
Enchantments
permits EnchantmentImpl {
    @Contract(pure=true)
    @NotNull
    public Registry.EnchantmentEntry registry();

    @Override
    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    @NotNull
    public static @NotNull Collection<@NotNull Enchantment> values() {
        return EnchantmentImpl.values();
    }

    @Nullable
    public static Enchantment fromNamespaceId(@NotNull String namespaceID) {
        return EnchantmentImpl.getSafe(namespaceID);
    }

    @Nullable
    public static Enchantment fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return Enchantment.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static Enchantment fromId(int id) {
        return EnchantmentImpl.getId(id);
    }
}

