/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.Enchantment;
import net.minestom.server.item.ItemHideFlag;
import net.minestom.server.item.ItemMetaImpl;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.ItemTags;
import net.minestom.server.item.attribute.ItemAttribute;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.Taggable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public sealed interface ItemMeta
extends TagReadable,
NetworkBuffer.Writer
permits ItemMetaImpl {
    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemMeta with(@NotNull @NotNull Consumer<@NotNull Builder> var1);

    @NotNull
    public NBTCompound toNBT();

    @NotNull
    public String toSNBT();

    @Contract(pure=true)
    default public int getDamage() {
        return this.getTag(ItemTags.DAMAGE);
    }

    @Contract(pure=true)
    default public boolean isUnbreakable() {
        return this.getTag(ItemTags.UNBREAKABLE);
    }

    @Contract(pure=true)
    default public int getHideFlag() {
        return this.getTag(ItemTags.HIDE_FLAGS);
    }

    @Contract(pure=true)
    @Nullable
    default public Component getDisplayName() {
        return this.getTag(ItemTags.DISPLAY_NAME);
    }

    @Contract(pure=true)
    @NotNull
    default public @NotNull List<@NotNull Component> getLore() {
        return this.getTag(ItemTags.LORE);
    }

    @Contract(pure=true)
    @NotNull
    default public Map<Enchantment, Short> getEnchantmentMap() {
        return this.getTag(ItemTags.ENCHANTMENTS);
    }

    @Contract(pure=true)
    @NotNull
    default public @NotNull List<@NotNull ItemAttribute> getAttributes() {
        return this.getTag(ItemTags.ATTRIBUTES);
    }

    @Contract(pure=true)
    default public int getCustomModelData() {
        return this.getTag(ItemTags.CUSTOM_MODEL_DATA);
    }

    @Contract(pure=true)
    @NotNull
    default public @NotNull Set<@NotNull String> getCanDestroy() {
        return Set.copyOf((Collection)this.getTag(ItemTags.CAN_DESTROY));
    }

    @Contract(pure=true)
    default public boolean canDestroy(@NotNull Block block) {
        return this.getCanDestroy().contains(block.name());
    }

    @Contract(pure=true)
    @NotNull
    default public @NotNull Set<@NotNull String> getCanPlaceOn() {
        return Set.copyOf((Collection)this.getTag(ItemTags.CAN_PLACE_ON));
    }

    @Contract(pure=true)
    default public boolean canPlaceOn(@NotNull Block block) {
        return this.getCanPlaceOn().contains(block.name());
    }

    public static sealed interface Builder
    extends Taggable
    permits ItemMetaImpl.Builder, ItemMetaView.Builder {
        @NotNull
        public ItemMeta build();

        @NotNull
        default public <T> Builder set(@NotNull Tag<T> tag, @Nullable T value) {
            this.setTag(tag, value);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder damage(int damage) {
            return this.set(ItemTags.DAMAGE, damage);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder unbreakable(boolean unbreakable) {
            return this.set(ItemTags.UNBREAKABLE, unbreakable);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder hideFlag(int hideFlag) {
            return this.set(ItemTags.HIDE_FLAGS, hideFlag);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder hideFlag(ItemHideFlag ... hideFlags) {
            int result = 0;
            for (ItemHideFlag hideFlag : hideFlags) {
                result |= hideFlag.getBitFieldPart();
            }
            return this.hideFlag(result);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder displayName(@Nullable Component displayName) {
            return this.set(ItemTags.DISPLAY_NAME, displayName);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder lore(@NotNull List<? extends Component> lore) {
            return this.set(ItemTags.LORE, lore.isEmpty() ? null : (List)List.class.cast(lore));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder lore(Component ... lore) {
            return this.lore(Arrays.asList(lore));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder enchantments(@NotNull Map<Enchantment, Short> enchantments) {
            return this.set(ItemTags.ENCHANTMENTS, Map.copyOf(enchantments));
        }

        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder enchantment(@NotNull Enchantment enchantment, short level) {
            HashMap<Enchantment, Short> enchantments = new HashMap<Enchantment, Short>(this.getTag(ItemTags.ENCHANTMENTS));
            enchantments.put(enchantment, level);
            return this.enchantments(enchantments);
        }

        @Contract(value="-> this")
        @NotNull
        default public Builder clearEnchantment() {
            return this.enchantments(Map.of());
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder attributes(@NotNull @NotNull List<@NotNull ItemAttribute> attributes) {
            return this.set(ItemTags.ATTRIBUTES, attributes.isEmpty() ? null : attributes);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder customModelData(int customModelData) {
            return this.set(ItemTags.CUSTOM_MODEL_DATA, customModelData);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder canPlaceOn(@NotNull @NotNull Set<@NotNull Block> blocks) {
            return this.set(ItemTags.CAN_PLACE_ON, blocks.stream().map(ProtocolObject::name).toList());
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder canPlaceOn(Block ... blocks) {
            return this.canPlaceOn(Set.of(blocks));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder canDestroy(@NotNull @NotNull Set<@NotNull Block> blocks) {
            return this.set(ItemTags.CAN_DESTROY, blocks.stream().map(ProtocolObject::name).toList());
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder canDestroy(Block ... blocks) {
            return this.canDestroy(Set.of(blocks));
        }
    }
}

