/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.registry.Registry;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

record TrimMaterialImpl(Registry.TrimMaterialEntry registry, int id) implements TrimMaterial
{
    static final AtomicInteger i = new AtomicInteger();
    private static final Registry.Container<TrimMaterial> CONTAINER = Registry.createContainer(Registry.Resource.TRIM_MATERIALS, (namespace, properties) -> new TrimMaterialImpl(Registry.trimMaterial(namespace, properties)));

    public TrimMaterialImpl(Registry.TrimMaterialEntry registry) {
        this(registry, i.getAndIncrement());
    }

    public static TrimMaterial get(String namespace) {
        return CONTAINER.get(namespace);
    }

    static Collection<TrimMaterial> values() {
        return CONTAINER.values();
    }

    @Override
    public NBTCompound asNBT() {
        return NBT.Compound(nbt -> {
            nbt.setString("asset_name", this.assetName());
            nbt.setString("ingredient", this.ingredient().namespace().asString());
            nbt.setFloat("item_model_index", this.itemModelIndex());
            nbt.set("override_armor_materials", (NBT)NBT.Compound(this.overrideArmorMaterials().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> NBT.String((String)((String)entry.getValue()))))));
            nbt.set("description", (NBT)NbtComponentSerializer.nbt().serialize(this.description()));
        });
    }
}

