/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.minestom.server.color.DyeColor;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.banner.BannerPattern;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

@ApiStatus.Experimental
public record BannerMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final String PATTERN_KEY = "Pattern";
    private static final String COLOR_KEY = "Color";
    private static final Tag<Component> CUSTOM_NAME = Tag.Component("CustomName").path("BlockEntityTag");
    private static final Tag<List<Pattern>> PATTERNS = Tag.Structure("Patterns", TagSerializer.fromCompound(Pattern::fromCompound, Pattern::asCompound)).path("BlockEntityTag").list().defaultValue(List.of());

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Pattern from(@NotNull DyeColor color, @NotNull BannerPattern pattern) {
        return new Pattern(color, pattern);
    }

    @Nullable
    public Component getCustomName() {
        return this.getTag(CUSTOM_NAME);
    }

    @NotNull
    public List<Pattern> getPatterns() {
        return this.getTag(PATTERNS);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Pattern(@NotNull DyeColor color, @NotNull BannerPattern pattern) {
        @NotNull
        public static Pattern fromCompound(@NotNull NBTCompound compound) {
            BannerPattern pattern;
            DyeColor color;
            DyeColor dyeColor = color = compound.containsKey(BannerMeta.COLOR_KEY) ? DyeColor.getValue(compound.getByte(BannerMeta.COLOR_KEY).byteValue()) : DyeColor.WHITE;
            BannerPattern type = compound.containsKey(BannerMeta.PATTERN_KEY) ? ((pattern = BannerPattern.fromIdentifier(compound.getString(BannerMeta.PATTERN_KEY))) != null ? pattern : BannerPattern.BASE) : BannerPattern.BASE;
            return new Pattern(color, type);
        }

        @NotNull
        public NBTCompound asCompound() {
            return NBT.Compound(Map.of(BannerMeta.COLOR_KEY, NBT.Byte((int)this.color.ordinal()), BannerMeta.PATTERN_KEY, NBT.String((String)this.pattern.identifier())));
        }
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        @NotNull
        public Builder customName(Component customName) {
            this.setTag(CUSTOM_NAME, customName);
            return this;
        }

        @NotNull
        public Builder patterns(@NotNull List<Pattern> patterns) {
            this.setTag(PATTERNS, patterns);
            return this;
        }

        @NotNull
        public Builder addPattern(Pattern pattern) {
            ArrayList<Pattern> newList = new ArrayList<Pattern>((Collection)this.getTag(PATTERNS));
            newList.add(pattern);
            return this.patterns(newList);
        }

        @NotNull
        public Builder removePattern(Pattern pattern) {
            ArrayList<Pattern> newList = new ArrayList<Pattern>((Collection)this.getTag(PATTERNS));
            newList.remove(pattern);
            return this.patterns(newList);
        }

        @NotNull
        public Builder clearPatterns() {
            return this.patterns(List.of());
        }
    }
}

