/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Experimental
public record BundleMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<List<ItemStack>> ITEMS = Tag.ItemStack("Items").list().defaultValue(List.of());

    @NotNull
    public List<ItemStack> getItems() {
        return this.getTag(ITEMS);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder items(@NotNull List<ItemStack> items) {
            this.setTag(ITEMS, items);
            return this;
        }

        @ApiStatus.Experimental
        public Builder addItem(@NotNull ItemStack item) {
            ArrayList<ItemStack> newList = new ArrayList<ItemStack>((Collection)this.getTag(ITEMS));
            newList.add(item);
            return this.items(newList);
        }

        @ApiStatus.Experimental
        public Builder removeItem(@NotNull ItemStack item) {
            ArrayList<ItemStack> newList = new ArrayList<ItemStack>((Collection)this.getTag(ITEMS));
            newList.remove(item);
            return this.items(newList);
        }
    }
}

