/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.List;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.firework.FireworkEffect;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record FireworkMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<List<FireworkEffect>> EFFECTS = Tag.Structure("Explosions", TagSerializer.fromCompound(FireworkEffect::fromCompound, FireworkEffect::asCompound)).path("Fireworks").list().defaultValue(List.of());
    private static final Tag<Byte> FLIGHT_DURATION = Tag.Byte("Flight").path("Fireworks");

    @NotNull
    public List<FireworkEffect> getEffects() {
        return this.getTag(EFFECTS);
    }

    @Nullable
    public Byte getFlightDuration() {
        return this.getTag(FLIGHT_DURATION);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder effects(List<FireworkEffect> effects) {
            this.setTag(EFFECTS, effects);
            return this;
        }

        public Builder flightDuration(byte flightDuration) {
            this.setTag(FLIGHT_DURATION, flightDuration);
            return this;
        }
    }
}

