/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.color.DyeColor;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.item.metadata.BannerMeta;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Experimental
public record ShieldMeta(@NotNull TagReadable readable) implements ItemMetaView<Builder>
{
    private static final String BASE_KEY = "Base";
    private static final String ENTITY_TAG = "BlockEntityTag";
    private static final Tag<Component> CUSTOM_NAME = Tag.Component("CustomName").path("BlockEntityTag");
    private static final Tag<Integer> BASE_TAG = Tag.Integer("Base").path("BlockEntityTag");
    private static final Tag<List<BannerMeta.Pattern>> PATTERNS = Tag.Structure("Patterns", TagSerializer.fromCompound(BannerMeta.Pattern::fromCompound, BannerMeta.Pattern::asCompound)).path("BlockEntityTag").list().defaultValue(List.of());

    @NotNull
    public DyeColor getBaseColor() {
        return DyeColor.getValue(this.getTag(BASE_TAG));
    }

    @Nullable
    public Component getCustomName() {
        return this.getTag(CUSTOM_NAME);
    }

    @NotNull
    public List<BannerMeta.Pattern> getPatterns() {
        return this.getTag(PATTERNS);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(@NotNull TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        @NotNull
        public Builder baseColor(@NotNull DyeColor dyeColor) {
            this.setTag(BASE_TAG, dyeColor.ordinal());
            return this;
        }

        @NotNull
        public Builder customName(@NotNull Component customName) {
            this.setTag(CUSTOM_NAME, customName);
            return this;
        }

        @NotNull
        public Builder patterns(@NotNull List<BannerMeta.Pattern> patterns) {
            this.setTag(PATTERNS, patterns);
            return this;
        }

        @NotNull
        public Builder addPattern(BannerMeta.Pattern pattern) {
            ArrayList<BannerMeta.Pattern> newList = new ArrayList<BannerMeta.Pattern>((Collection)this.getTag(PATTERNS));
            newList.add(pattern);
            return this.patterns(newList);
        }

        @NotNull
        public Builder removePattern(BannerMeta.Pattern pattern) {
            ArrayList<BannerMeta.Pattern> newList = new ArrayList<BannerMeta.Pattern>((Collection)this.getTag(PATTERNS));
            newList.remove(pattern);
            return this.patterns(newList);
        }

        @NotNull
        public Builder clearPatterns() {
            return this.patterns(List.of());
        }
    }
}

