/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record WrittenBookMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<Boolean> RESOLVED = Tag.Boolean("resolved").defaultValue(false);
    private static final Tag<WrittenBookGeneration> GENERATION = Tag.Integer("resolved").map(integer -> WrittenBookGeneration.values()[integer], Enum::ordinal);
    private static final Tag<String> AUTHOR = Tag.String("author");
    private static final Tag<String> TITLE = Tag.String("title");
    private static final Tag<List<Component>> PAGES = Tag.String("pages").map(arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).deserialize(arg_0), arg_0 -> ((GsonComponentSerializer)GsonComponentSerializer.gson()).serialize(arg_0)).list().defaultValue(List.of());

    public boolean isResolved() {
        return this.getTag(RESOLVED);
    }

    @Nullable
    public WrittenBookGeneration getGeneration() {
        return this.getTag(GENERATION);
    }

    @Nullable
    public String getAuthor() {
        return this.getTag(AUTHOR);
    }

    @Nullable
    public String getTitle() {
        return this.getTag(TITLE);
    }

    @NotNull
    public @NotNull List<@NotNull Component> getPages() {
        return this.getTag(PAGES);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public static enum WrittenBookGeneration {
        ORIGINAL,
        COPY_OF_ORIGINAL,
        COPY_OF_COPY,
        TATTERED;

    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder resolved(boolean resolved) {
            this.setTag(RESOLVED, resolved);
            return this;
        }

        public Builder generation(@Nullable WrittenBookGeneration generation) {
            this.setTag(GENERATION, generation);
            return this;
        }

        public Builder author(@Nullable String author) {
            this.setTag(AUTHOR, author);
            return this;
        }

        public Builder author(@Nullable Component author) {
            return this.author(author != null ? LegacyComponentSerializer.legacySection().serialize(author) : null);
        }

        public Builder title(@Nullable String title) {
            this.setTag(TITLE, title);
            return this;
        }

        public Builder title(@Nullable Component title) {
            return this.title(title != null ? LegacyComponentSerializer.legacySection().serialize(title) : null);
        }

        public Builder pages(@NotNull @NotNull List<@NotNull Component> pages) {
            this.setTag(PAGES, pages);
            return this;
        }

        public Builder pages(Component ... pages) {
            return this.pages(Arrays.asList(pages));
        }
    }
}

