/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map;

import java.util.List;
import net.minestom.server.network.packet.server.play.MapDataPacket;

public interface Framebuffer {
    public static final int WIDTH = 128;
    public static final int HEIGHT = 128;

    public byte[] toMapColors();

    default public MapDataPacket preparePacket(int mapId) {
        return this.preparePacket(mapId, 0, 0, 128, 128);
    }

    default public MapDataPacket preparePacket(int mapId, int minX, int minY, int width, int height) {
        byte[] colors;
        if (minX == 0 && minY == 0 && width == 128 && height == 128) {
            colors = this.toMapColors();
        } else {
            colors = new byte[width * height];
            byte[] mapColors = this.toMapColors();
            for (int y = minY; y < Math.min(128, minY + height); ++y) {
                for (int x = minX; x < Math.min(128, minX + width); ++x) {
                    byte color;
                    colors[Framebuffer.index((int)(x - minX), (int)(y - minY), (int)width)] = color = mapColors[Framebuffer.index(x, y, 128)];
                }
            }
        }
        return new MapDataPacket(mapId, 0, false, false, List.of(), new MapDataPacket.ColorContent((byte)width, (byte)height, (byte)minX, (byte)minY, colors));
    }

    public static int index(int x, int z) {
        return Framebuffer.index(x, z, 128);
    }

    public static int index(int x, int z, int stride) {
        return z * stride + x;
    }
}

