/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import net.kyori.adventure.audience.MessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChatPosition {
    CHAT(MessageType.CHAT),
    SYSTEM_MESSAGE(MessageType.SYSTEM),
    GAME_INFO(null);

    private final MessageType messageType;

    private ChatPosition(MessageType messageType) {
        this.messageType = messageType;
    }

    @Nullable
    public MessageType getMessageType() {
        return this.messageType;
    }

    public byte getID() {
        return (byte)this.ordinal();
    }

    @NotNull
    public static ChatPosition fromMessageType(@NotNull MessageType messageType) {
        return switch (messageType) {
            default -> throw new MatchException(null, null);
            case MessageType.CHAT -> CHAT;
            case MessageType.SYSTEM -> SYSTEM_MESSAGE;
        };
    }

    @NotNull
    public static ChatPosition fromPacketID(int id) {
        return switch (id) {
            case 0 -> CHAT;
            case 1 -> SYSTEM_MESSAGE;
            case 2 -> GAME_INFO;
            default -> throw new IllegalArgumentException("id must be between 0-2 (inclusive)");
        };
    }
}

