/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.advancements.FrameType;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AdvancementsPacket(boolean reset, @NotNull List<AdvancementMapping> advancementMappings, @NotNull List<String> identifiersToRemove, @NotNull List<ProgressMapping> progressMappings) implements ComponentHoldingServerPacket
{
    public AdvancementsPacket(boolean reset, @NotNull List<AdvancementMapping> advancementMappings, @NotNull List<String> identifiersToRemove, @NotNull List<ProgressMapping> progressMappings) {
        advancementMappings = List.copyOf(advancementMappings);
        identifiersToRemove = List.copyOf(identifiersToRemove);
        progressMappings = List.copyOf(progressMappings);
    }

    public AdvancementsPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BOOLEAN), reader.readCollection(AdvancementMapping::new), reader.readCollection(NetworkBuffer.STRING), reader.readCollection(ProgressMapping::new));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BOOLEAN, this.reset);
        writer.writeCollection(this.advancementMappings);
        writer.writeCollection(NetworkBuffer.STRING, this.identifiersToRemove);
        writer.writeCollection(this.progressMappings);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ADVANCEMENTS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        List<DisplayData> displayData = this.advancementMappings.stream().map(AdvancementMapping::value).map(Advancement::displayData).filter(Objects::nonNull).toList();
        List<Component> titles = displayData.stream().map(DisplayData::title).toList();
        List<Component> descriptions = displayData.stream().map(DisplayData::description).toList();
        ArrayList<Component> list = new ArrayList<Component>();
        list.addAll(titles);
        list.addAll(descriptions);
        return List.copyOf(list);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new AdvancementsPacket(this.reset, this.advancementMappings.stream().map(mapping -> mapping.copyWithOperator((UnaryOperator)operator)).toList(), this.identifiersToRemove, this.progressMappings);
    }

    public record AdvancementMapping(@NotNull String key, @NotNull Advancement value) implements NetworkBuffer.Writer,
    ComponentHolder<AdvancementMapping>
    {
        public AdvancementMapping(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), new Advancement(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.key);
            writer.write(this.value);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.value.components();
        }

        @Override
        @NotNull
        public AdvancementMapping copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.value.displayData == null ? this : new AdvancementMapping(this.key, (Advancement)this.value.copyWithOperator((UnaryOperator)operator));
        }
    }

    public record CriterionProgress(@Nullable Long dateOfAchieving) implements NetworkBuffer.Writer
    {
        public CriterionProgress(@NotNull NetworkBuffer reader) {
            this(reader.readOptional(NetworkBuffer.LONG));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeOptional(NetworkBuffer.LONG, this.dateOfAchieving);
        }
    }

    public record Criteria(@NotNull String criterionIdentifier, @NotNull CriterionProgress criterionProgress) implements NetworkBuffer.Writer
    {
        public Criteria(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), new CriterionProgress(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.criterionIdentifier);
            writer.write(this.criterionProgress);
        }
    }

    public record AdvancementProgress(@NotNull List<Criteria> criteria) implements NetworkBuffer.Writer
    {
        public AdvancementProgress(@NotNull List<Criteria> criteria) {
            criteria = List.copyOf(criteria);
        }

        public AdvancementProgress(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(Criteria::new));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(this.criteria);
        }
    }

    public record ProgressMapping(@NotNull String key, @NotNull AdvancementProgress progress) implements NetworkBuffer.Writer
    {
        public ProgressMapping(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), new AdvancementProgress(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.key);
            writer.write(this.progress);
        }
    }

    public record DisplayData(@NotNull Component title, @NotNull Component description, @NotNull ItemStack icon, @NotNull FrameType frameType, int flags, @Nullable String backgroundTexture, float x, float y) implements NetworkBuffer.Writer,
    ComponentHolder<DisplayData>
    {
        public DisplayData(@NotNull NetworkBuffer reader) {
            this(DisplayData.read(reader));
        }

        private DisplayData(DisplayData displayData) {
            this(displayData.title, displayData.description, displayData.icon, displayData.frameType, displayData.flags, displayData.backgroundTexture, displayData.x, displayData.y);
        }

        private static DisplayData read(@NotNull NetworkBuffer reader) {
            Component title = reader.read(NetworkBuffer.COMPONENT);
            Component description = reader.read(NetworkBuffer.COMPONENT);
            ItemStack icon = reader.read(NetworkBuffer.ITEM);
            FrameType frameType = FrameType.values()[reader.read(NetworkBuffer.VAR_INT)];
            Integer flags = reader.read(NetworkBuffer.INT);
            String backgroundTexture = (flags & 1) != 0 ? reader.read(NetworkBuffer.STRING) : null;
            Float x = reader.read(NetworkBuffer.FLOAT);
            Float y = reader.read(NetworkBuffer.FLOAT);
            return new DisplayData(title, description, icon, frameType, flags, backgroundTexture, x.floatValue(), y.floatValue());
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.COMPONENT, this.title);
            writer.write(NetworkBuffer.COMPONENT, this.description);
            writer.write(NetworkBuffer.ITEM, this.icon);
            writer.writeEnum(FrameType.class, this.frameType);
            writer.write(NetworkBuffer.INT, this.flags);
            if ((this.flags & 1) != 0) {
                assert (this.backgroundTexture != null);
                writer.write(NetworkBuffer.STRING, this.backgroundTexture);
            }
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.x));
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.y));
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.title, this.description);
        }

        @Override
        @NotNull
        public DisplayData copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new DisplayData((Component)operator.apply(this.title), (Component)operator.apply(this.description), this.icon, this.frameType, this.flags, this.backgroundTexture, this.x, this.y);
        }
    }

    public record Requirement(@NotNull List<String> requirements) implements NetworkBuffer.Writer
    {
        public Requirement(@NotNull List<String> requirements) {
            requirements = List.copyOf(requirements);
        }

        public Requirement(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(NetworkBuffer.STRING));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(NetworkBuffer.STRING, this.requirements);
        }
    }

    public record Advancement(@Nullable String parentIdentifier, @Nullable DisplayData displayData, @NotNull List<Requirement> requirements, boolean sendTelemetryData) implements NetworkBuffer.Writer,
    ComponentHolder<Advancement>
    {
        public Advancement(@Nullable String parentIdentifier, @Nullable DisplayData displayData, @NotNull List<Requirement> requirements, boolean sendTelemetryData) {
            requirements = List.copyOf(requirements);
        }

        public Advancement(@NotNull NetworkBuffer reader) {
            this(reader.readOptional(NetworkBuffer.STRING), reader.readOptional(DisplayData::new), reader.readCollection(Requirement::new), reader.read(NetworkBuffer.BOOLEAN));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeOptional(NetworkBuffer.STRING, this.parentIdentifier);
            writer.writeOptional(this.displayData);
            writer.writeCollection(this.requirements);
            writer.write(NetworkBuffer.BOOLEAN, this.sendTelemetryData);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.displayData != null ? this.displayData.components() : List.of();
        }

        @Override
        @NotNull
        public Advancement copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.displayData == null ? this : new Advancement(this.parentIdentifier, (DisplayData)this.displayData.copyWithOperator((UnaryOperator)operator), this.requirements, this.sendTelemetryData);
        }
    }
}

