/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.network.packet.server.play.data.ChunkData;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record ChunkDataPacket(int chunkX, int chunkZ, @NotNull ChunkData chunkData, @NotNull LightData lightData) implements ServerPacket
{
    public ChunkDataPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.INT), new ChunkData(reader), new LightData(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.chunkX);
        writer.write(NetworkBuffer.INT, this.chunkZ);
        writer.write(this.chunkData);
        writer.write(this.lightData);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.CHUNK_DATA;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

