/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record CraftRecipeResponse(byte windowId, String recipe) implements ServerPacket
{
    public CraftRecipeResponse(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.STRING));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.windowId);
        writer.write(NetworkBuffer.STRING, this.recipe);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.CRAFT_RECIPE_RESPONSE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

