/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record CustomChatCompletionPacket(@NotNull Action action, @NotNull @NotNull List<@NotNull String> entries) implements ServerPacket
{
    public CustomChatCompletionPacket(@NotNull Action action, @NotNull List<String> entries) {
        entries = List.copyOf(entries);
    }

    public CustomChatCompletionPacket(@NotNull NetworkBuffer reader) {
        this(reader.readEnum(Action.class), reader.readCollection(NetworkBuffer.STRING));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeEnum(Action.class, this.action);
        writer.writeCollection(NetworkBuffer.STRING, this.entries);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.CUSTOM_CHAT_COMPLETIONS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    public static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

