/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import net.minestom.server.MinecraftServer;
import net.minestom.server.attribute.Attribute;
import net.minestom.server.attribute.AttributeInstance;
import net.minestom.server.attribute.AttributeModifier;
import net.minestom.server.attribute.AttributeOperation;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EntityPropertiesPacket(int entityId, List<AttributeInstance> properties) implements ServerPacket
{
    public EntityPropertiesPacket {
        properties = List.copyOf(properties);
    }

    public EntityPropertiesPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(r -> {
            Attribute attribute = MinecraftServer.getAttributeManager().fromKey(reader.read(NetworkBuffer.STRING));
            double value = reader.read(NetworkBuffer.DOUBLE);
            int modifierCount = reader.read(NetworkBuffer.VAR_INT);
            AttributeInstance instance = new AttributeInstance(attribute, null);
            for (int i = 0; i < modifierCount; ++i) {
                AttributeModifier modifier = new AttributeModifier(reader.read(NetworkBuffer.UUID), "", reader.read(NetworkBuffer.DOUBLE), AttributeOperation.fromId(reader.read(NetworkBuffer.BYTE).byteValue()));
                instance.addModifier(modifier);
            }
            return instance;
        }));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.VAR_INT, this.properties.size());
        for (AttributeInstance instance : this.properties) {
            Attribute attribute = instance.getAttribute();
            writer.write(NetworkBuffer.STRING, attribute.key());
            writer.write(NetworkBuffer.DOUBLE, Double.valueOf(instance.getBaseValue()));
            Collection<AttributeModifier> modifiers = instance.getModifiers();
            writer.write(NetworkBuffer.VAR_INT, modifiers.size());
            for (AttributeModifier modifier : modifiers) {
                writer.write(NetworkBuffer.UUID, modifier.getId());
                writer.write(NetworkBuffer.DOUBLE, modifier.getAmount());
                writer.write(NetworkBuffer.BYTE, (byte)modifier.getOperation().getId());
            }
        }
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ENTITY_PROPERTIES;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

