/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EntityStatusPacket(int entityId, byte status) implements ServerPacket
{
    public EntityStatusPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.BYTE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.entityId);
        writer.write(NetworkBuffer.BYTE, this.status);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ENTITY_STATUS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

